class Pick::PostController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    prepare
  end

  def tree
    if params[:root] == 'source'
      prepare_company
      prepare_post
    else
      prepare_post
    end
    respond_to {|format|
      format.json
    }
  end

  # for test
  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:post_id].blank? || params[:rfw][:post_name].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :company_id   => params[:rfw][:company_id],
      :company_name => params[:rfw][:company_name],
      :post_id      => params[:rfw][:post_id],
      :post_name    => params[:rfw][:post_name],
    }
  end

  def prepare
    prepare_company
    prepare_post
  end

  def prepare_company
    @company_name = params[:company_name]
    if !@company_name.blank?
      @companies = picker_model_class("Company").find_like_name(@company_name,
                                                                :select => 'id, name',
                                                                :order => 'name')
    else
      @companies = picker_model_class("Company").find(:all, :select => 'id, name', :order => 'name')
    end
    
    prepare_post
    if !@post_name.blank?
      if @posts && @posts != []
        c_ids = picker_model_class("Post").find(:all, :conditions=>" id in (#{@posts.map(&:id).join(",")})").map(&:company_id).join(",")
        com = picker_model_class("Company").find(:all,:select=>"id, name" , :conditions=>"id in (#{c_ids})")
        @companies = @companies & com
      else
        @companies = []
      end
    end
  end

  def prepare_post
    @post_name = params[:post_name]
    if !@post_name.blank?
      @posts = picker_model_class("Post").find_like_name(@post_name,
                                                         :select => 'id, name, company_id',
                                                         :order => 'name')
    elsif /_(\d+)\z/ =~ params[:root]
      @posts = picker_model_class("Post").find_all_by_company_id($1,
                                                                 :select => 'id, name, company_id',
                                                                 :order => 'name')
    else
      @posts = picker_model_class("Post").find(:all, :select => 'id, name', :order => 'name')
    end
  end
end
