class Pick::PersonController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    if params[:company_name] || params[:organization_name] || params[:person_name]
      prepare
    end
  end

  def tree
    case params[:root]
    when /source/
      prepare_company
      prepare_organization
      prepare_person
    when /\Acompany_id/
      prepare_organization
      prepare_person
    when /\Aorganization_id/
      prepare_person
    end
    respond_to do |format|
      format.json
    end
  end

  # for test
  def test
  end
    
  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:person_id].blank? || params[:rfw][:person_name].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :company_id        => params[:rfw][:company_id],
      :company_name      => params[:rfw][:company_name],
      :organization_id   => params[:rfw][:organization_id],
      :organization_name => params[:rfw][:organization_name],
      :person_id         => params[:rfw][:person_id],
      :person_name       => params[:rfw][:person_name],
    }
  end

  def prepare
    prepare_company
    prepare_organization
    prepare_person
  end

  def prepare_company
    @company_name = params[:company_name]

    if !@company_name.blank?
      @companies = picker_model_class("Company").find_like_name(@company_name,
                                                                :select => 'id, name',
                                                                :order => 'name')
    else
      @companies = picker_model_class("Company").find(:all, :select => 'id, name', :order => 'name')
    end

    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).join(",")
        c = []
        picker_model_class("Person").find(:all,:conditions=>"id in (#{p})").each do |per_c|
          c << per_c.default_company_id if per_c.default_company_id && per_c.default_company_id != ""
        end
        c = c.join(",")
        if c && c != ""
          coms = picker_model_class("Company").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        else
          coms = []
        end
        @companies = @companies & coms
      else
        @companies = []
      end
    end
    
    prepare_organization
    if !@organization_name.blank?
      if @organizations && @organizations != []
        c = @organizations.map(&:company_id).join(",")
        if c && c != ""
          coms = picker_model_class("Company").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        else
          coms = []
        end
        @companies = @companies & coms
      else
        @companies = []
      end
    end
  end

  def prepare_organization
    @organization_name = params[:organization_name]
    if !@organization_name.blank?
      @organizations = picker_model_class("Organization").find_like_name(@organization_name, :select => 'id, name, company_id')
    else
      case params[:root]
      when /source/, ''
        @organizations = picker_model_class("Organization").all(:select => 'id, name, company_id', :order => 'name')
      when /\Aorganization_id_(\d+)_\d+\z/
        # nop
      when /\Acompany_id_(\d+)_\d+\z/
        @organizations = picker_model_class("Organization").find_all_by_company_id($1,
                                                                                   :select => 'id, name, company_id',
                                                                                   :order => 'name')
      else
        # nop
      end
    end

    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).uniq.join(",")
        o = []
        picker_model_class("Person").find(:all,:conditions=>"id in (#{p})").each do |per_p|
          o <<  per_p.default_organization_id if per_p.default_organization_id && per_p.default_organization_id != ""
        end
        o = o.uniq.join(",")
        if o && o != ""
          orgs = picker_model_class("Organization").find(:all, :select => 'id, name', :conditions=>"id in (#{o})", :order => 'name')
        else
          orgs = []
        end
        
        @organizations = @organizations & orgs
      else
        @organizations = []
      end
    end
  end

  def prepare_person
    @person_name = params[:person_name]
    if !@person_name.blank?
      @people = picker_model_class("Person").find_like_name(@person_name)
    else
      case params[:root]
      when /source/, /\Acompany_id_(\d+)_\d+\z/
        # nop
      when /\Aorganization_id_(\d+)_\d+\z/
        @people = picker_model_class("Organization").find($1).people
        
      when /\Agroup_id_(\d+)_\d+\z/
        @people = picker_model_class("Group").find($1).people
      when /\Apersonal_group_id_(\d+)_\d+\z/
        @people = picker_model_class("PersonalGroup").find($1).people
      when nil
        # nop
      else
        raise "invalid root : #{params[:root]}"
      end
    end
    begin
      if @people
      p = @people.map(&:id).join(",")
      c = CompanyMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
      o = OrganizationMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
      c_per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
      o_per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{o})", :order => 'name')
      @people = @people & c_per & o_per
      end
    rescue
      @people = nil
    end
  end
  
end
