# -*- coding: utf-8 -*-
class Pick::LumpPeopleController < Pick::LumpController
  # 内容が同じなので

  skip_before_filter :check_rfw_params
  skip_before_filter :filter_rfw_params
  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:people_ids].blank? ||
        params[:rfw][:people_names].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :people_ids => params[:rfw][:people_ids],
      :people_names => params[:rfw][:people_names],
    }
  end
end
