class Pick::LumpController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]
  before_filter :check_mode, :only => [:search]
  before_filter :set_variables, :except => [:tree, :test]

  def search
  end

  def search_company
    @mode = 'company'
  end

  def search_group
    @mode = 'group'
  end

  def search_personal_group
    @mode = 'personal_group'
  end

  def tree
    prepare
    respond_to do |format|
      format.json
    end
  end

  # for test
  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:model_id].blank? ||
        params[:rfw][:model_name].blank? ||
        params[:rfw][:model_value].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :model_id => params[:rfw][:model_id],
      :model_name => params[:rfw][:model_name],
      :model_value => params[:rfw][:model_value],
    }
  end

  def check_mode
    unless %w[company group personal_group].include?(params[:mode])
      raise ClientError, "no such mode : #{params[:mode]}"
    end
  end

  def set_variables
    @company_name        = params[:company_name]
    @organization_name   = params[:organization_name]
    @group_name          = params[:group_name]
    @personal_group_name = params[:personal_group_name]
    @person_name         = params[:person_name]
  end

  def prepare
    case params[:mode]
    when 'company'
      prepare_company
      prepare_organization
      prepare_person
    when 'group'
      prepare_group
      prepare_person
    when 'personal_group'
      prepare_personal_group
      prepare_person
    end
  end

  def prepare_company
    @company_name = params[:company_name]
    if !@company_name.blank?
      @companies = picker_model_class("Company").find_like_name(@company_name)
    else
      @companies = picker_model_class("Company").find(:all, :select => 'id, name', :order => 'name')
    end
    
    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).join(",")
        c = []
        picker_model_class("Person").find(:all,:conditions=>"id in (#{p})").each do |per_c|
          c << per_c.default_company_id if per_c.default_company_id && per_c.default_company_id != ""
        end
        c = c.join(",")
        if c && c != ""
          coms = picker_model_class("Company").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        else
          coms = []
        end
        @companies = @companies & coms
      else
        @companies = []
      end
    end
    
    prepare_organization
    if !@organization_name.blank?
      if @organizations && @organizations != []
        c = @organizations.map(&:company_id).join(",")
        if c && c != ""
          coms = picker_model_class("Company").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        else
          coms = []
        end
        @companies = @companies & coms
      else
        @companies = []
      end
    end
  end

  def prepare_organization
    @organization_name = params[:organization_name]
    if !@organization_name.blank?
      @organizations = picker_model_class("Organization").find_like_name(@organization_name,
                                                   :select => 'id, name, company_id')
    else
      @organizations = picker_model_class("Organization").find(:all, :select => 'id, name, company_id', :order => 'name')
    end
    
    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).uniq.join(",")
        o = []
        picker_model_class("Person").find(:all,:conditions=>"id in (#{p})").each do |per_p|
          o <<  per_p.default_organization_id if per_p.default_organization_id && per_p.default_organization_id != ""
        end
        o = o.uniq.join(",")
        if o && o != ""
          orgs = picker_model_class("Organization").find(:all, :select => 'id, name', :conditions=>"id in (#{o})", :order => 'name')
        else
          orgs = []
        end
        
        @organizations = @organizations & orgs
      else
        @organizations = []
      end
    end
  end

  def prepare_group
    @group_name = params[:group_name]
    if !@group_name.blank?
      @groups = picker_model_class("Group").find_like_name(@group_name)
    else
      @groups = picker_model_class("Group").find(:all, :select => 'id, name', :order => 'name')
    end
    
    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).join(",")
        g = GroupMember.find(:all, :conditions=>" person_id in (#{p})").map(&:group_id).join(",") if GroupMember.find(:all, :conditions=>" person_id in (#{p})")
        if g && g != ""
          grps = picker_model_class("Group").find(:all, :select => 'id, name', :conditions=>"id in (#{g})", :order => 'name')
        else
          grps = []
        end
        @groups = @groups & grps
      else
        @groups = []
      end
    end
  end

  def prepare_personal_group
    @personal_group_name = params[:personal_group_name]
    if !@personal_group_name.blank?
      @personal_groups = picker_model_class("PersonalGroup").find_like_name(@personal_group_name)
    else
      @personal_groups = picker_model_class("PersonalGroup").find(:all, :select => 'id, name', :order => 'name')
    end
    
    prepare_person
    if !@person_name.blank?
      if @people && @people != []
        p = @people.map(&:id).join(",")
        pg = PersonalGroupMember.find(:all, :conditions=>" person_id in (#{p})").map(&:personal_group_id).join(",") if PersonalGroupMember.find(:all, :conditions=>" person_id in (#{p})")
        if pg && pg != ""
          pgrps = picker_model_class("PersonalGroup").find(:all, :select => 'id, name', :conditions=>"id in (#{pg})", :order => 'name')
        else
          pgrps = []
        end
        @personal_groups = @personal_groups & pgrps
      else
        @personal_groups = []
      end
    end
    
    p_g = picker_model_class("PersonalGroup").find(:all, :select => 'id, name', :conditions=>"person_id = #{CacheEachRequest.current[:user].person_id}", :order => 'name')
    @personal_groups = @personal_groups & p_g
  end

  def prepare_person
    @person_name = params[:person_name]
    if !@person_name.blank?
      @people = picker_model_class("Person").find_like_name(@person_name, :select => '*')
    else
      case params[:root]
      when /source/, /\Acompany_id_(\d+)_\d+\z/
        # nop
      when /\Aorganization_id_(\d+)_\d+\z/
        @people = picker_model_class("Organization").find($1).people
        
      when /\Agroup_id_(\d+)_\d+\z/
        @people = picker_model_class("Group").find($1).people
      when /\Apersonal_group_id_(\d+)_\d+\z/
        @people = picker_model_class("PersonalGroup").find($1).people
      when nil
        # nop
      else
        raise "invalid root : #{params[:root]}"
      end
    end
    
    begin
      case params[:mode]
      when 'company'
        if @people
        p = @people.map(&:id).join(",")
        c = CompanyMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
        o = OrganizationMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
        c_per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        o_per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{o})", :order => 'name')
        @people = @people & c_per & o_per
        end
      when 'group'
        if @people
          p = @people.map(&:id).join(",")
          g = GroupMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
          per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{g})", :order => 'name')
          @people = @people & per
        end
      when 'personal_group'
        if @people
          p = @people.map(&:id).join(",")
          pg = PersonalGroupMember.find(:all, :conditions=>" person_id in (#{p})").map(&:person_id).join(",")
          per = picker_model_class("Person").find(:all, :select => 'id, name', :conditions=>"id in (#{pg})", :order => 'name')
          @people = @people & per
        end
      end
    rescue
      @people = nil
    end
  end
end
