class Pick::DiversityController < Pick::LumpController
  include Picker::Controller

  skip_before_filter :check_rfw_params
  skip_before_filter :filter_rfw_params
  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]
  before_filter :restore_params, :only => [:search]

  def search
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:mailto_ids].blank? ||
        params[:rfw][:mailto_names].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :mailto_ids => params[:rfw][:mailto_ids],
      :mailto_names => params[:rfw][:mailto_names]
    }
  end

  def restore_params
    params[:rfw].each{|key, value|
      if /(.+?)\[(.+?)\]/ =~ value
        instance_variable_set("@#{key}", params[$1][$2])
      else
        instance_variable_set("@#{key}", params[value])
      end
    }
    @mailto_people = picker_model_class("Person").joints(@mailto_ids)
    true
  end

end
