class Pick::CompanyController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    prepare
  end

  # for test
  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:company_id].blank? || params[:rfw][:company_name].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :company_id => params[:rfw][:company_id],
      :company_name => params[:rfw][:company_name],
    }
  end

  def prepare
    @name = params[:name]
    if @name
      @companies = picker_model_class("Company").find_like_name(@name,
                                                                :select => 'id, name',
                                                                :order => 'name')
    else
      @companies = picker_model_class("Company").find(:all, :select => 'id, name', :order => 'name')
    end
  end

end
