

class Pick::CalendarController < ApplicationController

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    prepare
  end

  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? || params[:rfw][:return_value].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :return_value => params[:rfw][:return_value]
    }
  end

  def prepare
    @year = (params[:year] || flash[:year] || Time.now.year).to_i
    @month = (params[:month] || flash[:month] || Time.now.month).to_i
    unless Date.valid_date?(@year, @month, 1)
      @year = Time.now.year
      @month = Time.now.month
    end
    @this = Date.new(@year, @month, 1)

    case params[:name]
    when 'previous_year'
      @this = @this << 12
    when 'previous_month'
      @this = @this << 1
    when 'next_month'
      @this = @this >> 1
    when 'next_year'
      @this = @this >> 12
    end

    @year = @this.year
    @month = @this.month

    @prev_month = (@this << 1)
    @next_month = (@this >> 1)
    @prev_year = (@this << 12)
    @next_year = (@this >> 12)

    @holidays = Hash.new(nil)

    # TODO: select only the holidays during the specified month
    Holiday.find(:all, :select => "day", :conditions => ["year = ? AND month = ?", @year, @month]).each do |holiday|
      @holidays[holiday.day] = true
    end

    @return_format = params[:return_format].blank? ? "yyyy/mm/dd" : params[:return_format]
    @alert_holiday = params[:alert_holiday]
  end
end
