# -*- coding: utf-8 -*-
# ファイル出力を制御する。
class OutputController < ApplicationController
  # <tt>edit</tt> へリダイレクトする。
  def index
    redirect_to :action => "edit"
  end

  # 出力の設定を編集する。
  def edit
    prepare
    @current_view = "view_output"
  end

  # CSV 出力の設定を編集する。
  def edit_csv
    prepare
    @current_view = "view_output"
  end

  # PDF 出力の設定を編集する。
  def edit_pdf
    prepare
    @current_view = "view_output"
  end

  # XML 出力の設定を編集する。
  def edit_xml
    prepare
    @current_view = "view_output"
  end

  # 出力する項目を並び替える。
  def sort
    prepare do
      if params[:config_output_items_tbody].is_a?(Array)
        n = 1
        params[:config_output_items_tbody].each do |config_output_item_id|
          if item = ConfigOutputItem.find(:first, :conditions => {:id => config_output_item_id, :config_output_id => @config_output.id})
            item.insert_at(n)
            n += 1;
          end
        end
      end
    end
    render :text => params[:config_output_items_tbody].inspect # FIXME
  end

  # 出力の設定を保存する。
  def save
    prepare do
      if params[:config_output].is_a?(Hash)
        @config_output.attributes = params[:config_output]
        @config_output.save
      end
      if params[:config_output_item].is_a?(Hash)
        params[:config_output_item].each_pair do |config_output_item_id, attributes|
          if config_output_item = ConfigOutputItem.find(:first, :conditions => {:id => config_output_item_id, :config_output_id => @config_output.id})
            config_output_item.attributes = attributes
            config_output_item.save
          end
        end
      end
    end
    t = Tempfile.open('output')
    @tempfile = File.basename(t.path)
    t.close(true)
    @current_view = "view_output"
    render :action => "edit"
  end

  def create
    prepare
    @display_to_list.narrow_to(session) if @display_to_list.narrowing?
    options = @display_to_list.query_options(session, &:selected?)
    begin
      temppath = Pathname.tempfile_path(params[:path])
      File.open(temppath, 'w+'){|file| file.write(@config_output.generate(options, session.dup)) }
      render :text => 'success', :status => 200
    rescue Iconv::IllegalSequence, Iconv::InvalidCharacter, Iconv::InvalidEncoding => ex
      # TODO エラーメッセージをわかりやすくする
      logger.info "[INFO] #{ex.class.to_s} : #{ex.message}"
      message = s_("rfw|ConfigOutput|Cannot convert illegal sequence, invalid character or invalid encoding.")
      render :text => message, :status => 400 # Bad request
    rescue ArgumentError => ex
      logger.warn "[WARN] #{ex.class.to_s} : #{ex.message} : #{params[:path]}"
      message = s_("rfw|ConfigOutput|illegal path error.")
      render :text => message, :status => 403 # Forbidden
    end
  end

  # 出力しダウンロードする。
  def download
    prepare
    if params[:path].blank?
      render :text =>s_("rfw|ConfigOutput|No path given"), :status => 400 # Bad request
      return
    end
    tempfile = File.join('/tmp', params[:path])
    if File.exist?(tempfile)
      send_file tempfile, :type => @config_output.mime_type,
                          :filename => @config_output.file_name(request.user_agent)
    else
      # NOTE fallback
      @display_to_list.narrow_to(session) if @display_to_list.narrowing?
      options = @display_to_list.query_options(session, &:selected?)
      send_data(@config_output.generate(options, session.dup), {
        :type => @config_output.mime_type,
        :filename => @config_output.file_name(request.user_agent)
      })
    end
  end

  # 出力の設定を初期化する。
  def clear
    @display_to_list = Display.find(params[:id])
    unless @display_to_list.is_a?(DisplayToList)
      raise "a DisplayToList required, but Display #{params[:id]}"
    end
    if config_output = @display_to_list.config_output
      config_output.destroy
    end
    prepare
    @current_view = "view_output"
    render :action => "edit"
  end

  # (試験用)
  def test
    @current_view = "view_m"
    @sub_view = "view_output"
  end

  private

  def prepare
    @display_to_list = Display.find(params[:id])
    unless @display_to_list.is_a?(DisplayToList)
      raise "a DisplayToList required, but Display #{params[:id]}"
    end
    unless @config_output = @display_to_list.config_output
      @config_output = @display_to_list.generate_config_output
    end
    yield if block_given?
    @config_output_items = @config_output.config_output_items.sort_by(&:position)
  end
end
