# 一覧設定画面の制御を行う。
class ListController < ApplicationController
  before_filter :verify_id

  # 一覧を一覧表示する。
  def index
    load_displays
    view_list
  end

  # 新規の一覧を追加する。
  def add
    source = DisplayToList.source_display_to_list(@product.id)
    raise ActiveRecord::RecordNotFound, "source list not found" unless source
    source.private_copy
    load_displays
    view_list
    render :template => "list/index"
  end

  # 既存の一覧を削除する。
  def destroy
    verify_display_id
    @display.destroy
    view_detail
    x_close_or_redirect_to :action => "index", :id => @product.id
  end

  # 既存の一覧を編集するための画面を開く。
  def edit
    verify_display_id
    view_detail
    @mode = :edit
  end

  # 既存の一覧を更新する。
  def update
    verify_display_id
    view_detail
    Language.all.each do |lang|
      @display.__send__("name_#{lang.code}=", [:display, :name].trav(params))
    end
    @display.save!
    default_list = DefaultList.find_or_initialize_by_product_id_and_user_id(@product.id, User.current_id)
    if params[:set_default].to_i > 0
      # set default
      default_list.display_id = @display.id
      default_list.save!
    elsif !default_list.new_record? && default_list.display_id == @display.id
      # drop default
      default_list.destroy
    end
    if params[:share].to_i > 0
      # at first, remove unchecked ones
      if params[:shared_list].blank?
        # destroy all shared
        SharedList.destroy_all(:display_id => @display.id)
      else
        @display.shared_lists.each do |shared_list|
          unless params[:shared_list].map(&:to_i).include?(shared_list.id)
            shared_list.destroy
          end
        end
      end
      # next, create a shared list
      begin
        roleable_class = params[:roleable_type].to_s.classify.constantize
        roleable = roleable_class.find(params[:roleable_id].to_i)
        @display.share(roleable)
      rescue
        # can be ignored
      end
    else
      # destroy all shared
      SharedList.destroy_all(:display_id => @display.id)
    end
    x_close_or_redirect_to :action => "index", :id => @product.id
  end

  # 選択された項目を並び替える。
  def order_selected
    verify_display_id
    if params[:selected_items].respond_to?(:map)
      ids = params[:selected_items].map(&:to_i)
      items = @display.items.sort_by {|item| item.layout.to_i}
      ids.each_with_index do |id,i|
        items = items.delete_if do |item|
          r = (item.id == id)
          if r
            item.layout   = i + 1
            item.position = i + 1
            item.save!
          end
          r
        end
      end
      s = ids.size
      items.each_with_index do |item, i|
        item.layout = 0
        item.position = s + i + 1
        item.save!
      end
    end
    render :nothing => true
  end

  # 選択されていない項目を並び替える。
  def order_unselected
    # nothing to do
    render :nothing => true
  end

  # 共有一覧をインポートする画面を表示する。
  def import
    view_import
    render :partial => "import"
  end

  # 共有一覧を検索する
  def search_to_import
    view_import
    @target = params[:target]
    unless @target
      render :partial => "import"
      return
    end
    @shared_lists = SharedList.find(:all, {
                                      :conditions => ["displays.product_id = ?", @product.id],
                                      :joins => :display,
                                      :order => "created_at",
                                    }).select do |shared_list|
      shared_list.include?(User.current.person) &&
        (@target[:display_sub].blank? || shared_list.display.name[@target[:display_sub]]) &&
        (@target[:creator_sub].blank? || shared_list.creator.name[@target[:creator_sub]])
    end
    render :partial => "import"
  end

  # 共有一覧の内容情報を取得する
  def glance_to_import
    view_list # x_form_tag needs @current_view
    @shared_list = SharedList.find(params[:shared_list_id].to_i)
    render :partial => "glance"
  end

  # 共有一覧を選択する
  def select_to_import
    shared_list = SharedList.find(params[:shared_list_id].to_i)
    shared_list.export(User.current.person)
    view_detail
    x_close_or_redirect_to :action => "index", :id => @product.id
  end

  private

  def view_list
    @parent_view = "view_m"
    @current_view = "view_list"
    @sub_view = "view_detail"
  end

  def view_detail
    @parent_view = "view_list"
    @current_view = "view_detail"
  end

  def view_import
    @parent_view = "view_list"
    @current_view = "view_detail"
    @target ||= {}
  end

  def verify_id
    raise ArgumentError, "missing product_id" unless params[:id]
    @product = Product.find(params[:id].to_i)
  end

  def verify_display_id
    raise ArgumentError, "missing display_id" unless params[:display_id]
    @display = Display.find(params[:display_id].to_i)
    items = Item.find(:all, :conditions => {:display_id => @display.id}, :order => "layout")
    @selected_items, @unselected_items = items.partition {|item| item.layout.to_i > 0}
  end

  def load_displays
    @displays = DisplayToListPrivate.find(:all, :conditions => {
                                            :product_id => @product.id,
                                            :person_id => User.current.person_id
                                          }, :order => "position")
  end
end
