# -*- coding: utf-8 -*-
# 関連文書機能を実装する。
class DocumentController < ApplicationController
  # 関連文書の詳細を表示する。
  def view
    fragment = URI.decode(params[:fragment])
    redirect_to "/##{fragment}"
  end

  # 関連文書を編集する。
  def edit
    prepare_to_edit
  end

  # 関連文書の一覧を表示する。
  def show
    prepare
  end

  # 関連文書をタブで表示する。
  def show_as_tab
    prepare
  end

  # 関連文書を削除する。
  def delete
    prepare_to_edit
    deleted = params[:deleted] || {}
    proc = lambda do |d|
      if d.new_record?
        deleted.fetch("#{d.target_type}_#{d.target_id}", nil).to_i == 1
      else
        deleted.fetch("#{d.id}", nil).to_i == 1
      end
    end
    session[:added_documents].delete_if(&proc)
    @documents.delete_if(&proc)
    deleted.each_pair do |key, value|
      if key.match(/\A([0-9]+)\z/) && value.to_i == 1
        if d = Document.find_by_id(key)
          session[:deleted_documents] |= [d]
        end
      end
    end
    return render(:action => "select")
  end

  # 関連文書の編集を取り止める。
  def cancel
    prepare_to_edit
    session[:added_documents].clear
    session[:deleted_documents].clear
    @documents = @relatable ? @relatable_product.documents_for(@relatable) : []
    return render(:action => "summary")
  end

  # 関連文書に関する現在のサマリを表示する。
  def summary
    prepare
  end

  # 関連付ける機能の選択欄を表示する。
  def product
  end

  # 関連付ける文書を選択する。
  def select
    prepare_to_edit
    unless @documents.find {|d| d.target_id == params[:target_id].to_i && d.target_type == params[:target_type] && d.target_product_id == params[:target_product_id].to_i}
      d = Document.new(:relatable_id   => defined?(@relatable) ? @relatable.id : nil,
                       :relatable_type => params[:type],
                       :relatable_product_id => @relatable_product.id,
                       :target_id      => params[:target_id].to_i,
                       :target_type    => params[:target_type],
                       :target_product_id => params[:target_product_id].to_i)
      session[:added_documents].push(d)
      @documents.push(d)
    end
  end

  # 関連付けの相互性を有効/無効にする。
  def toggle_mutual
    prepare_to_edit
    m = params[:mutual] || {}
    proc = lambda do |d|
      if d.new_record?
        d.mutual = (m.fetch("#{d.target_type}_#{d.target_id}", nil).to_i == 1)
      else
        d.mutual = (m.fetch("#{d.id}", nil).to_i == 1)
      end
    end
    session[:added_documents].each(&proc)
    @documents.each(&proc)
    return render(:action => "select")
  end

  # (試験用)
  def test
    prepare
    @current_view = "view_m"
    @sub_view = "view_de"
  end

  private

  def prepare(&block)
    @relatable_product = Product.find_by_id(params[:product_id])
    if params[:id].blank?
      @documents = []
      @document_nodes = []
    else
      @relatable = params[:type].constantize.find(params[:id])
      @documents = @relatable_product.documents_for(@relatable)
      @document_nodes = @relatable_product.document_nodes_for(@relatable)
    end
    @current_view = block_given? ? yield : "view_ds"
  rescue NameError
    raise NotFoundException, "relatable type not found: #{params[:type]}"
  end

  def prepare_to_edit
    prepare do
      session[:added_documents] ||= []
      if @relatable
        @documents |= session[:added_documents].select {|d| d.relatable == @relatable}
      else
        @documents |= session[:added_documents].select {|d| d.relatable_type == params[:type] && !d.relatable_id}
      end
      ids = Document.all.map(&:id)
      @documents = @documents.select {|doc| ids.include? doc.target_id }
      session[:deleted_documents] ||= []
      @documents -= session[:deleted_documents]
      "view_de"
    end
  end
end
