# To change this template, choose Tools | Templates
# and open the template in the editor.

class DiversityPickerController < ApplicationController

  before_filter :view_in_picker

  # allow registered return_to only; do not redirect to an arbitrary url
  PICKER_RETURN_TO = {
    :list_share => {:controller => "list", :action => "edit"},
    :picker_test => {:controller => "picker", :action => "test"},
  }.with_indifferent_access
  PICKER_ERROR_RETURN_TO = "/"

  # <tt>test</tt> へリダイレクトする。
  def index
    redirect_to :action => :test
  end

  # 一括で検索する。
  def lump
    set_mode_options
    case params[:mode]
    when "group"
      lump_group
    when "personal_group"
      lump_personal_group
    else
      person
    end
  end

  def diversity
    picker_session = session[:picker] || {}
    params[:diversity] ||= picker_session[:diversity_before_picker] || {}
    if params[:diversity][:pertinents].is_a?(Hash)
      params[:diversity][:pertinents] = params[:diversity][:pertinents].keys
    end
    if !params["commit"] && params["pick"]
      flash[:pick] = {
        :field => params[:return_field],
        :diversity => params[:diversity],
        :return_value => params[:diversity][:pertinents],
      }

       x_close_or_redirect_to return_to_url
      return
    end

    if params[:diversity][:pertinents]
      if params[:diversity][:pertinents].is_a?(Hash)
        params[:diversity][:pertinents] = params[:diversity][:pertinents].keys
      elsif params[:diversity][:pertinents].is_a?(String)
        params[:diversity][:pertinents] = params[:diversity][:pertinents].split(/,/)
      end
      @pertinents = Person.find(params[:diversity][:pertinents].map(&:to_i))
    else
      @pertinents = []
    end

    unless params["commit"]
      %w"company organization group".each do |key|
        if params[key]
          key_id, = params[key].keys
          case key_id
          when /\Aopen(\d+)/
            params["#{key}_id"] = $1
          when /\Apick(\d+)/
            params["#{key}_id"] = $1
            @pertinents += key.classify.constantize.find($1.to_i).people.find(:all)
          end
        end
      end
      if params["person"]
        key_id, = params["person"].keys
        @pertinents << Person.find(key_id)
      end
      @pertinents.uniq!
      if params["unset"]
        key_id, = params["unset"].keys
        key_id = key_id.to_i
        @pertinents.delete_if do |person|
          person.id == key_id
        end
      end
    end

    lump
  end

  private
  # グループを検索する。
  def group
    with_picker_scope(Group) do
      search :groups
      pass_params
    end
  end

  # 企業を検索する。
  def company
    with_picker_scope(Company) do
      search :companies
      pass_params
    end
  end

  # 組織を検索する。
  def organization
    with_picker_scope(Company, Organization) do
      if company = search_by_id(:company)
        search_under company, :organizations
      end
      pass_params :company
    end
  end
  # 個人を検索する。
  def person
    with_picker_scope(Company, Organization, Person) do
      if company = search_by_id(:company)
        if organization = search_by_id(:organization, company)
          search_under organization, :people
        end
      end
      pass_params :company, :organization
    end
  end
  #
  def set_mode_options
    @modes = [
      [s_("rfw|Picker|Company"), nil],
      [s_("rfw|Picker|Group"), "group"],
      [s_("rfw|Picker|Personal Group"), "personal_group"],
    ]
  end
  #
  def lump_group
    with_picker_scope(Group, Person) do
      group = search_by_id :group
      search_under group, :people
      pass_params :group
    end
  end

  #
  def lump_personal_group
    with_picker_scope(PersonalGroup, Person) do
      personal_group = search_by_id :personal_group
      search_under personal_group, :people
      pass_params :personal_group
    end
  end

  def return_to_url
    picker_session = session[:picker] || {}
    if return_to = PICKER_RETURN_TO[params[:return_to]]
      return return_to
    elsif picker_session[:return_to]
      return picker_session[:return_to]
    else
      return PICKER_ERROR_RETURN_TO
    end
  end

  def view_in_picker
    if /\Aview_[a-z0-9]+\z/ =~ params[:view]
      @current_view = params[:view]
    else
      @current_view = "view_picker"
    end
    @title = s_("rfw|title|Diversity Picker")
    @return_to_url = return_to_url
  end

  def search(table_name)
    singular = table_name.to_s.singularize
    model_class = singular.classify.constantize
    name = params["#{singular}_name"]
    if name.blank?
      items = model_class.find(:all)
    else
      items = find_like_name(model_class, name)
    end
    case table_name.to_sym
    when :companies
      items = lift_by_membership(User.current.person.companies, items)
    end
    instance_variable_set "@#{table_name}", items
    return items
  end

  def search_under(scope, table_name)
    return [] unless scope
    params["#{scope.class.to_s.underscore}_id"] = scope.id
    singular = table_name.to_s.singularize
    items = scope.__send__(table_name)
    name = params["#{singular}_name"]
    unless name.blank?
      items = find_like_name(items, name)
    end
    case table_name.to_sym
    when :organizations
      items = lift_by_membership(User.current.person.organizations, items)
    end
    instance_variable_set "@#{table_name}", items
    return items
  end
  #
  def search_by_id(singular, scope=nil)
    name_hidden = "#{singular}_name_hidden"
    name = "#{singular}_name"
    singular_id = "#{singular}_id"
    if params[name_hidden] && params[name_hidden] != params[name]
      params[singular_id] = nil
      params[:organization_id] = nil if singular.to_sym == :company
      params[name_hidden] = params[name]
    end
    table_name = singular.to_s.pluralize
    if scope
      items = search_under scope, table_name
    else
      items = search table_name
    end
    unless params[singular_id].blank?
      target_id = params[singular_id].to_i
      it = items.find {|i| i.id == target_id}
    end
    it ||= items[0]
    return it
  end

  def pass_params(*singulars)
    @pass_params_form = {}
    [
      :return_to,
      :return_field,
      :view,
    ].each do |key|
      @pass_params_form[key] = params[key] if params[key]
    end
    singulars.each do |singular|
      ["#{singular}_id", "#{singular}_name_hidden"].each do |key|
        key = key.to_sym
        @pass_params_form[key] = params[key] if params[key]
      end
    end

    @pass_params_link = @pass_params_form.dup
    [
      :mode,
    ].each do |key|
      @pass_params_link[key] = params[key] if params[key]
    end
    singulars.each do |singular|
      key = "#{singular}_name".to_sym
      @pass_params_link[key] = params[key] if params[key]
    end
  end

  def method_scoping(model_class)
    if model_class == Person
      return {
        :find => {
          :order => "people.name,people.id",
          :readonly => true,
        }
      }
    elsif model_class == PersonalGroup
      return {
        :find => {
          :conditions => {:person_id => User.current.person_id},
          :order => "personal_groups.name,personal_groups.id",
          :readonly => true,
        }
      }
    end
    table_name = model_class.table_name
    return {
      :find => {
        :order => "#{table_name}.name,#{table_name}.id",
        :readonly => true,
      }
    }
  end

  #
  def with_picker_scope(model_class, *rest, &block)
    if model_class
      model_class.__send__(:with_scope, method_scoping(model_class)) do
        if rest.empty?
          block.call
          render unless performed?
        else
          with_picker_scope(*rest, &block)
        end
      end
    end
  end

  def find_like_name(scope, name)
    find_like(scope, "name", name)
  end

  def find_like(scope, column, value)
    escape = '^'
    name = scope.connection.quote_like(value, escape)
    return scope.find(:all, :conditions => ["#{column} LIKE ? ESCAPE ?", "%#{value}%", escape])
  end

  def lift_by_membership(my_all_list, list)
    my_ids = my_all_list.map(&:id)
    my_list, other_list = list.partition do |item|
      my_ids.include?(item.id)
    end
    return my_list + other_list
  end


end
