# 添付ファイル機能を実装している。
class AttachmentController < ApplicationController
  # 添付ファイルの一覧を表示する。
  def show
    prepare
  end

  # 添付ファイルに関する現在のサマリを表示する。
  def summary
    prepare
  end

  # 添付ファイルを編集する。
  def edit
    prepare_to_edit
  end

  # 添付ファイルをアップロードする。
  def upload
    prepare_to_edit
    @attachment = Attachment.new do |a|
      a.attachable_id   = params[:id]
      a.attachable_type = params[:type]
      a.description     = params[:attachment]["description"]
    end
    begin
      file_class = params[:attachment]["file_type"].constantize
    rescue NameError
      return reload
    end
    content = params[:attachment]["file_content"]
    return reload if content.blank?
    file = file_class.new :name => content.original_filename, :mime_type => content.content_type
    begin
      file_class.transaction do
        if file.save
          if file.store(content)
            @attachment.file = file
            session[:uploaded_attachments].push(@attachment)
            return reload
          end
        end
      end
    rescue ConfigAttachment::FilenameMaximumBytesizeError => e
      flash[:warning] = s_("rfw|flash|warning|Upload a file of name of size <= %{max_bytesize}") % {:max_bytesize => ConfigAttachment::FILENAME_MAXBYTESIZE}
    rescue ConfigAttachment::FilenameProhibitedCharacterError => e
      flash[:warning] = s_("rfw|flash|warning|Upload a file of name without characters %{chars}") % {:chars => ConfigAttachment::FILENAME_PROHIBITED_CHARS.map {|c| "'#{c}'"}.join(', ')}
    rescue ConfigAttachment::MaximumLengthError => e
      flash[:warning] = s_("rfw|flash|warning|Upload a file of length <= %{maximum_length}.") % {:maximum_length => ConfigAttachment.current.maximum_length}
    end
    reload
  end

  # 添付ファイルを削除する。
  def delete
    if prepare_to_edit
      if params[:type]
        if params[:attachment]
          conditions = {
            :id              => params[:attachment],
            :attachable_id   => params[:id],
            :attachable_type => params[:type],
          }
          session[:deleted_attachments] |= Attachment.find(:all, :conditions => conditions)
        end
        if params[:binary_object]
          session[:uploaded_attachments].delete_if do |attachment|
            attachment.file_type == "BinaryObject" && params[:binary_object].map(&:to_i).include?(attachment.file_id) && attachment.file.destroy
          end
        end
        if params[:storage_object]
          session[:uploaded_attachments].delete_if do |attachment|
            attachment.file_type == "StorageObject" && params[:storage_object].map(&:to_i).include?(attachment.file_id) && attachment.file.destroy
          end
        end
      end
    end
    reload
  end

  # 添付ファイルの編集を取り消す。
  def cancel
    if prepare_to_edit
      session[:uploaded_attachments].clear
      session[:deleted_attachments].clear
    end
  end

  # 添付ファイルをダウンロードする。
  def download
    begin
      attachment = Attachment.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "attachment not found: #{params[:id]}"
    end
    file = attachment.file
    return send_data(file.content, :type => file.mime_type, :filename => filename_to_download(file.name)) if file.is_a?(BinaryObject)
    return send_file(file.path, :type => file.mime_type, :filename => filename_to_download(file.name)) if file.is_a?(StorageObject)
    raise NotFoundException, "file not found"
  end

  # (試験用)
  def test
    if prepare
      @current_view = "view_m"
      @sub_view = "view_ae"
    end
  end

  # (試験用)
  def test_execute
    session[:deleted_attachments].delete_if(&:destroy)
    session[:uploaded_attachments].delete_if(&:save)
    redirect_to :action => "test", :id => params[:id], :type => params[:type]
  end

  # (試験用)
  def test_close
    session[:deleted_attachments] = []
    session[:uploaded_attachments] = []
    redirect_to :action => "test", :id => params[:id], :type => params[:type]
  end

  private

  def prepare
    unless @attachment
      begin
        @attachment = Attachment.new(:file_type => ConfigAttachment.current.default_file_type,
                                     :attachable_id => params[:id],
                                     :attachable_type => params[:type])
      rescue NameError
        raise NotFoundException, "no records of config_attachments"
      end
    end
    @attachable = @attachment.attachable
    @attachments = @attachable ? @attachable.attachments : []
    @current_view = block_given? ? yield : "view_as"
  end

  def prepare_to_edit
    prepare do
      session[:uploaded_attachments] ||= []
      @attachments |= session[:uploaded_attachments].select {|a| a.attachable == @attachable}
      session[:deleted_attachments] ||= []
      @attachments -= session[:deleted_attachments]
      "view_ae"
    end
  end

  def reload
    responds_to_parent do
      render :update do |page|
        # NOTE: page.replace_html etc. are unavailable around 'responds_to_parent'.
        # page.replace_html 'view_attachment', :template => "attachment/edit"
        p = {
          :id   => params[:id],
          :type => params[:type],
        }
        page << "new Ajax.Updater('view_ae', '#{url_for(:action => "edit")}', {parameters: #{p.to_json}})"
      end
    end
    return
  end
end
