require "test/unit"
require "timestamps_as_string"

class TimestampsAsStringTest < Test::Unit::TestCase
  def assert_convert_from_string_timestamp(expected, actual)
    actual = TimestampsAsString.convert_from_string_timestamp(actual)
    assert_equal(expected, actual)
  end
  def test_convert_from_string_timestamp
    assert_convert_from_string_timestamp(Time.utc(2007, 8, 9), "20070809")
    assert_convert_from_string_timestamp(Time.utc(2007, 8, 9, 10), "2007080910")
    assert_convert_from_string_timestamp(Time.utc(2007, 8, 9, 10, 11), "200708091011")
    assert_convert_from_string_timestamp(Time.utc(2007, 8, 9, 10, 11, 12), "20070809101112")
    assert_raise(ArgumentError) do
      TimestampsAsString.convert_from_string_timestamp("2007080910111213")
    end
    assert_convert_from_string_timestamp(nil, nil)
  end
end
