# PjcTaskPagination
require "pagination"
module ActionController
  module Pagination
   def attachment_list_paginate(collection_id, attachments,attachment_count, options={})
      Pagination.validate_options!(collection_id, options, true)
      attachment_list_paginator_and_collection_for(collection_id, attachments,attachment_count,options)
   end
   
   def attachment_list_paginator_and_collection_for(collection_id, attachments,attachment_count, options) #:nodoc:
      klass = options[:class_name].constantize
      page  = (params[options[:parameter]] || 1).to_i    
      count = attachment_count
      paginator = Paginator.new(self, count, options[:per_page], page)
      
      last_page = count.to_i%options[:per_page].to_i
      pages = (count / options[:per_page].to_i).to_i
      pages += 1 if last_page != 0 || pages == 0
      
      if pages == 1
        start_date = 0
      elsif page > pages
        start_date = (pages - 1) * options[:per_page].to_i
      else
        start_date = (page - 1) * options[:per_page].to_i
      end
      
      collection = attachments[start_date,options[:per_page]]
    
      return paginator, collection 
   end
   
   def attachment_list_count_collection_for_pagination(model,attachments_id, options)
      model.count(:conditions => "attachments.id in (#{attachments_id.join(',')})",
                  :include => options[:include],
                  :select => (options[:group] ? "DISTINCT #{options[:group]}" : options[:count]))
   end
   
   def attachment_list_find_collection_for_pagination(model, attachments_id, options, paginator)
      model.find(:all, :conditions =>"attachments.id in (#{attachments_id.join(',')})",
                 :order => options[:order_by] || options[:order],
                 :select => options[:select], :limit => options[:per_page],
                 :group => options[:group], :offset => paginator.current.offset)
   end
   private :paginator_and_collection_for

  end
end
