desc "Generate graphs of model relationships to 'model_graph.png' or a specific format with FORMAT=X (ex: png/gif/jpe/ps/svg)."

task :model_graph => :environment do
  require "application"
  format = ENV["FORMAT"] || "png"
  IO.popen("dot -q -T#{format}", "w+") do |gv|
    gv.puts("digraph x {")
    Dir.glob("app/models/**/*.rb").each do |path|
      require_dependency path rescue nil
    end
    models = Set.new
    ObjectSpace.each_object(Class) do |klass|
      next unless klass.ancestors.include? ActiveRecord::Base
      models << klass.to_s
    end
    models.sort.each do |class_name|
      klass = class_name.constantize
      next if klass.reflect_on_all_associations.empty?
      gv.puts(class_name)
      klass.reflect_on_all_associations.each do |assoc|
        assoc_name = assoc.name.to_s.camelize.singularize
        gv.puts("#{class_name} -> #{assoc_name}[label=#{assoc.macro.to_s}]")
      end
    end
    gv.puts("}")
    gv.close_write
    file = "model_graph.#{format.downcase}"
    File.open(file, "w") do |f|
      f.print(gv.read)
    end
    puts "=> #{file}"
  end
end
