class ModelGraphController < ActionController::Base
  MIME_TYPE = {
    'png' => "image/png",
    'gif' => "image/gif",
    'jpeg' => "image/jpeg",
    'svg' => "application/xml"
  }

  def index
    format = params[:format] || "png"
    format = "png" unless MIME_TYPE.include? format
    gv = IO.popen("dot -q -T#{format}", "w+")
    gv.puts("digraph x {")
    Dir.glob("app/models/**/*.rb").each do |path|
      require_dependency path
    end
    models = Set.new
    ObjectSpace.each_object(Class) do |klass|
      next unless klass.ancestors.include? ActiveRecord::Base
      models << klass.to_s
    end
    models.sort.each do |class_name|
      klass = class_name.constantize
      next if klass.reflect_on_all_associations.empty?
      gv.puts(class_name)
      klass.reflect_on_all_associations.each do |assoc|
        assoc_name = assoc.name.to_s.camelize.singularize
        gv.puts("#{class_name} -> #{assoc_name}[label=#{assoc.macro.to_s}]")
      end
    end
    gv.puts("}")
    gv.close_write
    headers['Content-type'] = MIME_TYPE[format]
    render :text => gv.read
  end
end
