ActiveRecord::Schema.define(:version => 1) do

  ['', 'wf_'].each do |prefix|
    create_table "#{prefix}languages", :force => true do |t|
      t.column "code",    :string,                      :null => false, :limit => 2
      t.column "name_po", :integer,                     :null => false
    end

    create_table "#{prefix}coffees", :force => true do |t|
      t.column "name_po",       :integer,               :null => false
      t.column "country_po",    :integer,               :null => false
    end

    create_table "#{prefix}po_messages", :force => true do |t|
      t.column "type",         :string,                :null => false
      t.column "msgid",        :string,                :null => false
      t.column "msgid_plural", :string
      t.column "msgid_n",      :string
      t.column "modified",     :boolean
    end

    create_table "#{prefix}po_translations", :force => true do |t|
      t.column "type",          :string,                :null => false
      t.column "po_message_id", :integer,               :null => false
      t.column "msgstr",        :string
      t.column "msgstr_0",      :string
      t.column "msgstr_1",      :string
      t.column "msgstr_2",      :string
      t.column "msgstr_3",      :string
    end
  end
end
