require "test/init"
require "init"
require "person"
require "company"
require "company_member"

class ActsAsPeriodicTest < Test::Unit::TestCase
  fixtures :people, :companies, :company_members

  def test_find
    assert_equal([CompanyMember.find(1)],
                 CompanyMember.find(:all, :conditions => {:person_id => 1}))
  end

  def test_count
    assert_equal 1, CompanyMember.count(:conditions => {:person_id => 1})
  end

  def test_find_with_period
    assert_equal([CompanyMember.find_with_period(1), CompanyMember.find_with_period(6)],
                 CompanyMember.find_with_period(:all, :conditions => {:person_id => 1}))
  end

  def test_count_with_period
    assert_equal 2, CompanyMember.count_with_period(:conditions => {:person_id => 1})
  end

  def test_find_through_associations
    assert_equal 2, Person.find(1).companies.size
  end

  def test_has_many_with_class_name
    assert_equal 3, Company.find(2).members.size
  end

end
