# -*- coding: utf-8 -*-
# app/models/storage.rb のクラス Storage をテストする。

require 'test_helper'

class StorageTest < ActiveSupport::TestCase
  fixtures :domains, :users, :people, :storages

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # Storage#current で現在のドメインに応じた設定を返すことをテストする。
  def test_current
    User.current = users(:tesla)
    assert_equal storages(:one), Storage.current
  end

  # Storage#available? で保存場所として利用できるかどうかを判定する。
  def test_available?
    d = "#{Rails.root}/tmp"
    r = Dir.mkdir(d) rescue nil
    assert storages(:one).available?
    assert !storages(:three).available?
  ensure
    Dir.rmdir(d) if r
  end
end
