# app/models/pjc_business_card.rb のクラス PjcBusinessCard をテストする。

require File.dirname(__FILE__) + '/../test_helper'

class PjcBusinessCardTest < ActiveSupport::TestCase
  # Replace this with your real tests.
  fixtures(:business_cards,:business_card_companies,:business_card_branches)
  set_fixture_class :business_cards => "PjcBusinessCard" 

  def setup
    @business_card = business_cards(:one)
  end

  # PjcBusinessCard#domain_id() が動作することをテストする。
  def test_domain_id
    assert_equal 1, @business_card.domain_id
    assert_equal 2, business_cards(:domain_2).domain_id
  end

  # picker business_card_company　に必要なデータ取得をテスト
  def test_picker_find
    assert_kind_of PjcBusinessCard, @business_card
    assert_not_nil @business_card.domain_id
    assert_not_nil @business_card.company_id
    assert_not_nil @business_card.code

    assert_equal @business_card.company.id, @business_card.company_id
    assert_equal @business_card.branch.id, @business_card.company_branch_id
    assert_not_nil @business_card.company.name
    assert_not_nil @business_card.branch.name
  end
end
