# app/models/pjc_business_card_branch.rb のクラス PjcBusinessCardBranch をテストする。

require File.dirname(__FILE__) + '/../test_helper'

class PjcBusinessCardBranchTest < ActiveSupport::TestCase
  # Replace this with your real tests.
  fixtures(:business_card_branches,:business_card_companies)
  set_fixture_class :business_card_branches => "PjcBusinessCardBranch" 

  def setup
    @business_card_branch = business_card_branches(:one)
  end

  # PjcBusinessCardBranches#domain_id() が動作することをテストする。
  def test_domain_id
    assert_equal 1, @business_card_branch.domain_id
    assert_equal 2, business_card_branches(:domain_2).domain_id
  end

  # picker business_card_company　に必要なデータ取得をテスト
  def test_picker_find
    assert_kind_of PjcBusinessCardBranch, @business_card_branch
    assert_not_nil @business_card_branch.domain_id
    assert_not_nil @business_card_branch.company_id
    assert_not_nil @business_card_branch.name
    assert_not_nil @business_card_branch.name_with_in

    assert_equal @business_card_branch.header.id, @business_card_branch.company_id
    assert_not_nil @business_card_branch.header.name
  end
end
