# -*- coding: utf-8 -*-
# app/models/person.rb のクラス Person をテストする。

require 'test_helper'

class PersonTest < ActiveSupport::TestCase
  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos,
           :personal_group_members)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # Permission#domain_id がドメイン ID を返すことをテストする。
  def test_domain
    assert_equal 1, people(:one).domain_id
  end

  # Permission#posts がドメイン ID の配列を返すことをテストする。
  def test_posts
    _test_x :posts, :one => [1]
  end

  # Permission#companies が会社 ID の配列を返すことをテストする。
  def test_companies
    _test_x :companies, :one => [1], :two => [1]
  end

  # Permission#companies が組織 ID の配列を返すことをテストする。
  def test_organizations
    _test_x :organizations, :one => [1], :two => [1]
  end

  # Permission#companies がグループ ID の配列を返すことをテストする。
  def test_groups
    _test_x :groups, :two => [1], :abe => [2]
  end

  # Permission#exists_with_people? が動作することをテストする。
  def test_exists_with_people?
    assert Person.exists_with_people?(people(:one), people(:one))
    assert !Person.exists_with_people?(people(:one), people(:two))
  end

  # 削除された際に関連する company_members が削除される。
  def test_company_members__dependent_destroy
    assert_difference('CompanyMember.count', -1) do
      people(:two).destroy
    end
  end

  # 削除された際に関連する posted_tos が削除される。
  def test_posted_tos__dependent_destroy
    assert_difference('PostedTo.count', -1) do
      people(:one).destroy
    end
  end

  # 削除された際に関連する organization_members が削除される。
  def test_organization_members__dependent_destroy
    assert_difference('OrganizationMember.count', -1) do
      people(:one).destroy
    end
  end

  # 削除された際に関連する group_members が削除される。
  def test_group_members__dependent_destroy
    assert_difference('GroupMember.count', -1) do
      people(:two).destroy
    end
  end

  # 削除された際に関連する personal_group_members が削除される。
  def test_personal_group_members__dependent_destroy
    assert_difference('PersonalGroupMember.count', -1) do
      people(:two).destroy
    end
  end

  # メールの受信が可能かどうかの判定をテストする。
  def test_can_be_recipient?
    assert people(:one).can_be_recipient?
    assert !people(:geeko).can_be_recipient?
    assert !people(:tesla4).can_be_recipient?
  end

  private

  def _test_x(m, h)
    h.each_pair do |k, v|
      x = people(k).__send__ m
      assert_equal v, x.map(&:id).sort
    end
  end

end
