# -*- coding: utf-8 -*-
# app/models/organization.rb のクラス Organization をテストする。

require 'test_helper'

class OrganizationTest < ActiveSupport::TestCase
  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos,
           :grant_ons, :permissions)

  # Organization#exists_with_people? が動作することをテストする。
  def test_exists_with_people?
    assert Organization.exists_with_people?(people(:nisiyama), people(:abe))
    assert !Organization.exists_with_people?(people(:one), people(:geeko))
  end

  # Organization#find_with_period が find と異なる動作することをテストする。
  def test_find_with_period
    assert 2, Organization.find(:all).size
    assert 3, Organization.find_with_period(:all).size
  end
  
  # 更新される際に必要なら関連する grant_on の期間も更新する。
  def test_update_grant_ons
    o = organizations(:one)
    o.inception = "19880808"
    o.expiry    = "20121212"
    assert o.save

    g = GrantOn.find(2)
    assert_equal "20070903", g.inception
    assert_equal "20121212", g.expiry

    o.inception = "20080101"
    o.expiry    = "20151212"
    assert o.save
    g.reload
    assert_equal "20080101", g.inception
    assert_equal "20121212", g.expiry
  end
end
