require 'test_helper'

class NarrowingCondition::ProjectTest < ActiveSupport::TestCase
  fixtures :narrowings, :projects

  def test_text
    x = NarrowingCondition::Project.new(narrowings(:project_narrow_p))
    assert_equal "project1 プロジェクト1", x.text(:project_id => 1)
  end

  def test_condition
    narrowing = narrowings(:project_narrow_p)
    Narrowing.set_current(narrowing, :project_id, 1)
    Narrowing.set_current(narrowing, :project_segment_id, '')
    x = NarrowingCondition::Project.new(narrowing)
    assert_equal "foos.bar = #{::Project.quote_value(1)}", x.condition("foos", "bar")
  end

end
