# -*- coding: utf-8 -*-
# app/models/mail_queue.rb のクラス MailQueue をテストする。

require 'test_helper'

class MailQueueTest < ActiveSupport::TestCase
  fixtures :domains, :people, :users, :mail_queues

  EXPECTED_RECIPIENTS = [
    [:one, [1,2]],
    [:two, [3,4,5,8]],
  ]

  # MailQueue#recipients は宛先の配列を返す。
  def test_recipients
    EXPECTED_RECIPIENTS.each do |name, ids|
      recipients = mail_queues(name).recipients
      recipients.each {|r| assert_kind_of Person, r}
      assert_equal ids, recipients.map(&:id).sort
    end
  end
end
