# -*- coding: utf-8 -*-
# app/models/item.rb のクラス Item をテストする。

require 'test_helper'

require 'ostruct'

class ItemTableLayoutTest < ActiveSupport::TestCase
  include ItemTableLayout

  def o(hash)
    return OpenStruct.new(hash)
  end

  def os(*layouts)
    items = layouts.map do |l|
      o(:layout => l.to_f)
    end
    items.delete_if {|item| item.layout.to_i <= 0 }
    return items.sort_by {|item| item.layout }
  end

  def test_to_item_table_layout
    b = proc do |i|
      i.layout
    end
    assert_equal [], to_table_layout(os(nil))
    assert_equal [], to_table_layout(os(0))
    assert_equal [
      [[1]],
    ], to_table_layout(os(1), &b)
    assert_equal [
      [[1], [2]],
    ], to_table_layout(os(1, 2), &b)
    assert_equal [
      [[1], [2]],
    ], to_table_layout(os(2, 1), &b)
    assert_equal [
      [[1], [2]],
      [[3]],
    ], to_table_layout(os(1, 2, 3), &b)
    assert_equal [
      [[1], [2]],
      [[3]],
    ], to_table_layout(os(2, 3, 1), &b)
    assert_equal [
      [[1], [2, 2]],
      [[3]],
    ], to_table_layout(os(2, 3, 1, 2), &b)
    assert_equal [
      [[1], [2.1, 2.2]],
      [[3]],
    ], to_table_layout(os(2.2, 3, 1, 2.1), &b)
    assert_equal [
      [[1], [2.1, 2.2]],
      [[4]],
    ], to_table_layout(os(2.2, 4, 1, 2.1), &b)
    assert_equal [
      [[1], [2]],
      [[3]],
      [[5]],
    ], to_table_layout(os(2, 3, 1, 5), &b)
    assert_equal [
      [[1], [2]],
      [[3.1, 3.2]],
      [[5]],
    ], to_table_layout(os(2, 3.1, 3.2, 1, 5), &b)
    assert_equal [
      [[1], [2]],
      [[3.1, 3.2, 3.3], [4.5]],
      [[5]],
    ], to_table_layout(os(2, 3.1, 3.3, 3.2, 1, 5, 4.5), &b)
    assert_equal [
      [[1], [2]],
      [[4]],
      [[5]],
    ], to_table_layout(os(2, 4, 1, 5), &b)
    assert_equal [
      [[1], [2]],
      [[4]],
      [nil],
      [[7]],
    ], to_table_layout(os(2, 4, 1, 7), &b)
  end
end
