# -*- coding: utf-8 -*-
# app/models/item_proper.rb のクラス ItemProper をテストする。

require 'test_helper'

class ItemProperTest < ActiveSupport::TestCase

  fixtures :items

  # カレンダー参照を行うかどうかを判定する。
  def test_calendar?
    item = ItemProper.find(99916)
    assert item.__send__(:calendar?)
    item = ItemProper.find(99913)
    assert !item.__send__(:calendar?)
  end

  # カレンダーでの表示に用いるフォーマットを返す。
  def test_calendar_format
    item = items(:grant_product_edit_detail_4)
    assert_equal 'yyyymmdd', item.calendar_format
    item = ItemProper.new(:input_parameter => 'calendar(yyyy-mm-dd)')
    assert_equal 'yyyy-mm-dd', item.calendar_format
    item = ItemProper.new(:input_parameter => 'calendar')
    assert_equal 'yyyy/mm/dd', item.calendar_format
  end

  # カレンダーで休日を警告するかどうかを返す。
  def test_calendar_alert_holiday?
    item = items(:grant_product_edit_detail_4)
    assert item.calendar_alert_holiday?
    item = ItemProper.new(:input_parameter => 'calendar(yyyy-mm-dd, false)')
    assert !item.calendar_alert_holiday?
    item = ItemProper.new(:input_parameter => 'calendar')
    assert item.calendar_alert_holiday?
  end

  # 日付に関するカラムに対応する項目について set_attributes で書き出す。
  def test_set_attributes__date_under_limit
    item = ItemProper.new(:model_name => "MatterReport", :column_name => "delivery_date", :validates_year_month_day => true)
    assert item.writable?
    x = mock('date_under_limit')
    x.expects(:delivery_date=).with("2009-05-01")
    item.set_attributes(x, {:delivery_date => "2009/05/01"})
  end

  # 日付に関するカラムに対応する項目について set_attributes で書き出す。
  def test_set_attributes__date_over_limit
    item = ItemProper.new(:model_name => "Organization", :column_name => "inception", :validates_year_month_day => true)
    assert item.writable?
    x = mock('date_over_limit')
    x.expects(:inception=).with("20090501")
    item.set_attributes(x, {:inception => "2009/05/01"})
  end

  # 年月に関するカラムに対応する項目について set_attributes で書き出す。
  def test_set_attributes__date_under_limit
    item = ItemProper.new(:model_name => "MatterReport", :column_name => "delivery_date", :validates_year_month => true)
    assert item.writable?
    x = mock('year_month_under_limit')
    x.expects(:delivery_date=).with("2009-05")
    item.set_attributes(x, {:delivery_date => "2009/05"})
  end

  def test_to_data__checkbox
    item = ItemProper.new(:input_type => "checkbox", :input_parameter => "T,F", :column_name => "to_s")
    assert_equal 'T', item.to_data(true)
    assert_equal 'T', item.to_data('true')
    assert_equal 'T', item.to_data('T')
    assert_equal 'T', item.to_data(1)
    assert_equal 'T', item.to_data('1')
    assert_equal 'F', item.to_data(false)
    assert_equal 'F', item.to_data(nil)
    assert_equal 'F', item.to_data('False')
    assert_equal 'F', item.to_data('f')
    assert_equal 'F', item.to_data('')
    assert_equal 'F', item.to_data(0)
    assert_equal 'F', item.to_data('0')
  end

end
