# -*- coding: utf-8 -*-
# app/models/input_option.rb のクラス InputOption をテストする。

require 'test_helper'

class InputOptionTest < ActiveSupport::TestCase
  fixtures(:languages, :po_messages, :po_translations, :users, :input_options,
           :input_option_categories, :input_option_values)

  # InputOption#options_for_select の動作をテストする。
  def test_options_for_select
    assert_equal([["none", "0"], ["A1", "1"], ["B2", "2"], ["C3", "3"], ["D4", "4"], ["E5", "5"]],
                 InputOption.options_for_select("item_layout_list", 6))
  end

  # InputOption.option_name は対応する値をもつ選択肢の名前を返す。
  def test_option_name
    assert_equal "none", InputOption.option_name("item_layout_list", "0")
  end

  # InputOption.name_po_with_category_and_name は対応する値をもつ選択肢の名前を返す。
  def test_name_po_with_category_and_name
    assert_equal 999815, InputOption.name_po_with_category_and_name("matter_report_category", "randd")
  end

  # InputOption.name_pos_with_category_and_head は対応する値をもつ選択肢の名前を返す。
  def test_name_pos_with_category_and_head
    assert_equal [999815], InputOption.name_pos_with_category_and_head("matter_report_category", "ran")
  end

  # InputOption.name_pos_with_category_and_tail は対応する値をもつ選択肢の名前を返す。
  def test_name_pos_with_category_and_tail
    assert_equal [999815], InputOption.name_pos_with_category_and_tail("matter_report_category", "ndd")
  end

  # InputOption.name_pos_with_category_and_include は対応する値をもつ選択肢の名前を返す。
  def test_name_pos_with_category_and_include
    assert_equal [999815], InputOption.name_pos_with_category_and_include("matter_report_category", "and")
  end

  # InputOption#generate_input_options が与えられたカテゴリから選択肢を生成する。
  def test_generate_input_options
    assert InputOption.generate_input_options("foo")
    assert_equal 3, InputOption.find_all_by_category("foo").size
  end
end
