# -*- coding: utf-8 -*-
# app/models/holiday.rb のクラス Holiday をテストする。

require 'test_helper'

class HolidayTest < ActiveSupport::TestCase
  fixtures :holidays

  def test_create_holiday
    holiday = Holiday.new(:domain_id => 1,
                          :year  => 2008,
                          :month =>   11,
                          :day   =>   20)
    assert holiday.save
    holiday.reload
    assert_equal '20081120', holiday.ymd
  end

  def test_update_holiday
    holiday = holidays(:oct_sat_1)
    holiday.year = 2009
    assert holiday.save
    assert_equal '20091006', holiday.ymd
  end

  # Holiday#ymd= を使用できないことのテスト
  def test_update_holiday__ymd
    holiday = holidays(:oct_sat_1)
    assert_raise(RuntimeError){
      holiday.ymd = '20071006'
    }
  end

  # Holiday#ymd を外部から変更できないことのテスト
  def test_update_holiday__ymd_2
    holiday = holidays(:oct_sat_1)
    holiday[:ymd] = '20071006'
    assert_raise(ActiveRecord::RecordNotSaved){
      holiday.save!
    }
    holiday.reload
    assert_nil holiday.ymd
  end
end
