# -*- coding: utf-8 -*-
# app/models/expense.rb のクラス Expense を
# ProductDetailed 向けの主テーブルのモデルとしてテストする。
# ExpenseDetail のテストも参照すること。

require 'test_helper'

class ExpenseTest < ActiveSupport::TestCase
  fixtures :expenses

  # Expense#details で詳細項目全体を取得できることをテストする。
  def test_details
    e = Expense.find(1)
    details = e.details
    assert_kind_of Array, details
    assert_equal 3, details.size
    details.each do |d|
      assert_kind_of ExpenseDetail, d
    end
  end
end
