# -*- coding: utf-8 -*-
# app/models/domain.rb のクラス Domain をテストする。

require 'test_helper'

class DomainTest < ActiveSupport::TestCase
  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # Domain#exists_with_people?() の動作をテストする。
  def test_exists_with_people?
    assert Domain.exists_with_people?(people(:one), people(:maeda))
    assert !Domain.exists_with_people?(people(:second_domain_6), people(:geeko))
  end
end
