# -*- coding: utf-8 -*-
# app/models/display.rb のクラス Display をテストする。

require 'test_helper'

class DisplayTest < ActiveSupport::TestCase
  fixtures :users, :domains, :products, :displays

  def setup
    CacheEachRequest.clear
    Clock.time = Clock.now
  end

  def teardown
    CacheEachRequest.clear
    Clock.reset
  end

  # Display#inject_logic の動作をテストする。
  def test_inject_logic
    d = displays(:edit8)
    x = domains(:one)
    pool = HashWithIndifferentAccess.new
    assert d.inject_logic(:pre, x, :update, pool)
    assert d.inject_logic(:post , x, :update, pool)
    pool = HashWithIndifferentAccess.new
    assert d.inject_logic(:pre, x, :destroy, pool)
    assert d.inject_logic(:post , x, :destroy, pool)
  end

  def test_after_create
    User.current = users(:admin)
    PoMessageSingular.delete_all
    d = DisplayToShow.create!(:domain_id     => 1,
                              :code          => "TEST",
                              :product       => products(:workshop),
                              :name_po       => 0,
                              :position      => 1,
                              :enabled       => true,
                              :button_new    => true,
                              :button_edit   => true,
                              :button_delete => false,
                              :button_copy   => false)
    expected_items = [
                      %w[Workshop domain_id],
                      %w[Workshop name],
                      %w[Workshop ymd],
                      %w[Workshop project_segment_id],
                      %w[Workshop promoter_id],
                      %w[Workshop promoter_type],
                      %w[Workshop members],
                      %w[Workshop created_at],
                      %w[Workshop updated_at],
                      %w[Workshop created_by],
                      %w[Workshop updated_by],
                      %w[Workshop created_in],
                      %w[Workshop updated_in],
                      %w[Workshop lock_version],
                     ]
    d.items.sort_by(&:column_name).zip(expected_items.sort_by{|v| v[1] }).each do |actual, expected|
      assert_equal(actual.model_name, expected[0])
      assert_equal(actual.column_name, expected[1])
    end
    expected_msgids = [
                       "Workshop|Domain",
                       "Workshop|Name",
                       "Workshop|Ymd",
                       "Workshop|Project segment",
                       "Workshop|Promoter",
                       "Workshop|Promoter type",
                       "Workshop|Members",
                       "Workshop|Created at",
                       "Workshop|Updated at",
                       "Workshop|Created by",
                       "Workshop|Updated by",
                       "Workshop|Created in",
                       "Workshop|Updated in",
                       "Workshop|Lock version",
                      ]
    actual = PoMessageSingular.find(:all, :conditions => ["msgid like ?", "Workshop%"])
    assert_equal actual.map(&:msgid).sort, expected_msgids.sort
  end
end
