# -*- coding: utf-8 -*-
# app/models/design_ticket.rb のクラス DesignTicket をテストする。

require 'test_helper'

class DesignTicketTest < ActiveSupport::TestCase
  fixtures :domains, :users, :design_tickets
  
  # DesignTicket.give が有効な ticket を返すことをテストする。
  def test_give
    user = User.find(2)
    ticket = DesignTicket.give(user)
    assert_kind_of DesignTicket, ticket
    assert_equal 1, ticket.domain_id
    assert_equal 2, ticket.user_id
    assert ticket.token.length > 16
  end

  # DesignTicket.take が引数の情報に該当する有効な ticket を返すことをテストする。
  # さらに指定された場合にはその ticket を削除することをテストする。
  def test_take
    t = DesignTicket.take(:user_id => 2, :domain_id => 1, :token => 'unique0')
    assert_equal design_tickets(:one), t
    assert DesignTicket.take(:user_id => 2, :domain_id => 1, :token => 'unique0', :invalidate => true)
    assert !DesignTicket.take(:user_id => 2, :domain_id => 1, :token => 'unique0')
    assert DesignTicket.take(:user_id => 2, :domain_id => 1, :token => 'unique1', :invalidate => true)
  end

  # DesignTicket.take が引数の情報に該当する有効な ticket があるかどうか判定することをテストする。
  # さらに指定された場合にはその ticket を削除することをテストする。
  def test_valid?
    assert_equal true, DesignTicket.valid?(:user_id => 2, :domain_id => 1, :token => 'unique1', :invalidate => true)
    assert !DesignTicket.valid?(:user_id => 2, :domain_id => 1, :token => 'unique1')
    assert_equal true, DesignTicket.valid?(:user_id => 2, :domain_id => 1, :token => 'unique0', :invalidate => true)
  end

  # 別の DesignTicket インスタンスを保存する前に古いレコードが削除されることをテストする。
  def test_gc
    assert_equal 3, DesignTicket.count
    assert_kind_of DesignTicket, DesignTicket.create(:user_id => 2, :domain_id => 1, :token => "asdfghjkl")
    assert_equal 3, DesignTicket.count
  end
end
