# -*- coding: utf-8 -*-
# app/models/counter.rb のクラス Counter をテストする。

require 'test_helper'

class CounterTest < ActiveSupport::TestCase
  fixtures :domains, :counters

  # Counter#format() の出力と例外をテストする。
  def test_format
    assert_format_strftime "%Y%m-障害-00001", "f=yyyymm", "-障害-", "s=FOOS.5"
    assert_format_strftime "0778:%y/%m/%d", "s=bars.4", ":", "f=yy/mm/dd"
    assert_format_strftime "%y", "f=yy"
    assert_format_strftime "%Y", "f=yyyy"
    assert_format_strftime "%y%m", "f=yymm"
    assert_format_strftime "%y-%m", "f=yy-mm"
    assert_format_strftime "%y/%m", "f=yy/mm"
    assert_format_strftime "%y%m%d", "f=yymmdd"
    assert_format_strftime "%y-%m-%d", "f=yy-mm-dd"
    assert_format_strftime "%y/%m/%d", "f=yy/mm/dd"
    assert_format_strftime "%Y%m", "f=yyyymm"
    assert_format_strftime "%Y-%m", "f=yyyy-mm"
    assert_format_strftime "%Y/%m", "f=yyyy/mm"
    assert_format_strftime "%Y%m%d", "f=yyyymmdd"
    assert_format_strftime "%Y-%m-%d", "f=yyyy-mm-dd"
    assert_format_strftime "%Y/%m/%d", "f=yyyy/mm/dd"
    assert_format_raise "s=NoSuchTable.10"
    assert_format_raise "f="
    assert_format_raise "f=y"
    assert_format_raise "s="
    assert_format_raise "s=foos"
    assert_format_raise "s=foos."
    #assert_format_raise "f=yyy"
    #assert_format_raise "f=yyyy/dd"
  end

  private

  def assert_format(expected, *args)
    assert_equal expected, Counter.format(*args)
  end

  def assert_format_strftime(expected, *args)
    assert_format(Date.today.strftime(expected), *args)
  end

  def assert_format_raise(*args)
    assert_raise(ArgumentError) do
      Counter.format(*args)
    end
  end
end
