# -*- coding: utf-8 -*-
# app/models/config_output_item.rb のクラス ConfigOutputItem をテストする。

require 'test_helper'

class ConfigOutputItemTest < ActiveSupport::TestCase
  fixtures(:domains, :users, :permissions,
           :products, :displays, :items,
           :config_outputs, :config_output_items)

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("admin")
  end

  def teardown
    CacheEachRequest.clear
  end

  # ConfigOutputItem#clear() が設定を初期化することをテストする。
  def test_clear
    (1..6).each do |id|
      i = ConfigOutputItem.find(id)
      i.clear(1)
      assert i.enabled?
      assert_equal i.item.name, i.name
      assert_equal 1, i.position
    end
  end
end
