# -*- coding: utf-8 -*-
require 'test_helper'

class AutoDocumentObserverTest < ActiveSupport::TestCase

  fixtures(:domains, :products, :auto_documents,
           :documents, :document_edges, :document_paths,
           :workshops, :matter_reports)

  def setup
    @observer = AutoDocumentObserver.new
  end

  def test_after_create
    assert_difference('Document.count', 1) do
      @observer.after_create(workshops(:one))
    end
  end

  def test_before_destroy
    assert_difference('Document.count', -1) do
      @observer.before_destroy(matter_reports(:one))
    end
  end

end
