# -*- coding: utf-8 -*-
# app/models/async_mailer.rb のクラス AsyncMailer をテストする。

require 'test_helper'

class AsyncMailerTest < ActiveSupport::TestCase
  FIXTURES_PATH = File.dirname(__FILE__) + '/../fixtures'
  CHARSET = "utf-8"

  include ActionMailer::Quoting

  fixtures :mail_histories, :domains, :mail_queues, :attachments, :binary_objects, :storage_objects, :matters

  def setup
    ActionMailer::Base.delivery_method = :test
    ActionMailer::Base.perform_deliveries = true
    ActionMailer::Base.deliveries = []

    @expected = TMail::Mail.new
    @expected.set_content_type "text", "plain", { "charset" => CHARSET }
    @expected.mime_version = '1.0'
  end

  # AsyncMailer#create_formatted_mail() が機能するかテストする。
  def test_formatted_mail
    mail_history = MailHistory.find(1)

    @expected.subject = mail_history.subject
    # @expected.body    = read_fixture('formatted_mail')
    @expected.body    = mail_history.body + "\n"
    @expected.date    = Time.now
    @expected.from    = mail_history.from_value
    @expected.to      = mail_history.recipient_value

    assert_match /Content-Type: text\/plain/, @expected.encoded
    assert_equal @expected.encoded, AsyncMailer.create_formatted_mail(mail_history, @expected.date).encoded
  end

  def test_formatted_mail__attachment
    now = Time.now
    mail_queue = mock('mail_queue', {
                        :has_attachment? => true,
                        :field_type => "to",
                        :document => Matter.find(1),
                      })
    mail_history = mock('mail_history', {
                          :subject => "a subject",
                          :from_value => "x@example.com",
                          :recipient_value => "y@example.com",
                          :body => "これは本文です。",
                          :mail_queue => mail_queue,
                        })
    assert_match /Content-Type: multipart\/mixed/, AsyncMailer.create_formatted_mail(mail_history, now).encoded
  end

  private

  def read_fixture(action)
    IO.readlines("#{FIXTURES_PATH}/async_mailer/#{action}")
  end

  def encode(subject)
    quoted_printable(subject, CHARSET)
  end
end
