# -*- coding: utf-8 -*-
# lib/acts_as_joint.rb のモジュール ActiveRecord::Acts::Joint をテストする。

require 'test_helper'

class ActsAsJointTest < ActiveSupport::TestCase
  fixtures :domains

  def test_joints
    assert_equal [], Domain.joints(nil)
    assert_equal [], Domain.joints("")
    assert_equal [], Domain.joints([])
    assert_equal [], Domain.joints(1234321)
    assert_equal [1], Domain.joints("1").map(&:id)
    assert_equal [1], Domain.joints(1).map(&:id)
    assert_equal [1,2,3], Domain.joints("1, 2, 3").map(&:id)
    assert_equal [1,2,3], Domain.joints([1, "2", 3, 3]).map(&:id)
    assert_equal [2], Domain.joints("1090909, 2,34567").map(&:id)
    assert_equal [1,2], Domain.joints("1,2,1,2").map(&:id)
  end
end
