require File.dirname(__FILE__) + '/../test_helper'
require 'test/unit'
require 'password_util'

class PasswordUtilTest < Test::Unit::TestCase
  fixtures :users

  def test_change_password_success
    user = User.find(1)
    new_password = 'btest'
    PasswordUtil.change_password(user, 'atest', new_password, new_password)
    assert User.authenticate(user.login, new_password)
  end

  def test_change_password_password_mismatch_error
    user = User.find(1)
    assert_raise(PasswordUtil::PasswordMismatchError) do
      PasswordUtil.change_password(user, 'atest', 'btest', 'ctest')
    end
  end

  def test_change_password_authentication_failed_error
    user = User.find(1)
    assert_raise(PasswordUtil::PasswordMismatchError) do
      PasswordUtil.change_password(user, 'atest', 'btest', 'ctest')
    end
  end

  def test_force_change_password
    user = User.find(1)
    new_password = 'btest'
    PasswordUtil.force_change_password(user, new_password)
    assert User.authenticate(user.login, new_password)
  end
end
