# -*- coding: utf-8 -*-
# 権限の制御をテストする。

require File.dirname(__FILE__) + '/../test_helper'

class ActsAsPermissibleParentTest < ActionController::IntegrationTest
  fixtures :domains, :users, :people, :products, :companies, :organizations, :groups, :example_projects, :example_works, :example_issues

  def setup
    CacheEachRequest.clear
    @p = example_projects(:one)
    @w = example_works(:a)
    @i = example_issues(:a)
  end

  def teardown
    CacheEachRequest.clear
  end

  # ユーザが指定されていない場合は readable? が成功する。
  def test_readable__without_user
    assert @p.readable?
    assert @w.readable?
    assert @i.readable?
  end

  # 管理者については常に readable? が成功する。
  def test_readable__example_project_admin
    User.current = users(:admin)
    assert @p.readable?
    assert @w.readable?
    assert @i.readable?
  end

  # 権限のないユーザについて readable? が失敗する。
  def test_readable__example_project_failure
    User.current = users(:deletable_user)
    assert !@p.readable?
    assert !@w.readable?
    assert !@i.readable?
  end

  # 管理者を与えると常に writable_for? が成功する。
  def test_writable_for__example_project_admin
    admin = users(:admin)
    assert @p.writable_for?(admin.id)
    assert @w.writable_for?(admin.id)
    assert @i.writable_for?(admin.id)
  end

  # 権限のないユーザを与えると writable_for? が失敗する。
  def test_writable_for__example_project_failure
    user = users(:deletable_user)
    assert !@p.writable_for?(user.id)
    assert !@w.writable_for?(user.id)
    assert !@i.writable_for?(user.id)
  end

  # 権限のないユーザでも削除の際の :dependent オプションは効く
  def test_has_many__dependent
    User.current = users(:deletable_user)
    assert_difference('ExampleWork.count_with_permission', -4) do
      assert_difference('ExampleIssue.count_with_permission', -4) do
        @p.destroy
      end
    end
  end

end
