# 権限の制御をテストする。

require File.dirname(__FILE__) + '/../test_helper'

class AccessControlTest < ActionController::IntegrationTest
  include Session
  fixtures :domains, :people, :users, :grant_ons, :permissions
  self.use_transactional_fixtures = false

  # 新しい権限が設定された場合に適切に関連するオブジェクトが作成されるかどうかをテストする。
  def test_initialize_permissions
    person = people(:for_permission_test)
    user = User.create(:domain_id => 1, :person_id => person.id, :login => 'permissiontest', :salt => 'salt', :salted_password => 'tlas')
    assert user
    perms = Permission.find(:all, :conditions => {:user_id => user, :grant_on_id => grant_ons(:person_1)})
    assert !perms.empty?
    perms = Permission.find(:all, :conditions => {:user_id => user, :grant_on_id => grant_ons(:domain_1)})
    assert !perms.empty?
  end

  # Permission.permissible_conditions および Permission.invisible_conditions が
  # 適切な戻り値を返すことをテストする。
  def test_permissible_conditions
    admin = login "admin", "atest"
    admin.assert_equal "1 = 1", Permission.permissible_conditions(:product)
    admin.assert_equal "0 = 1", Permission.invisible_conditions(:product)
    tesla = login "tesla", "atest"
    tesla.assert Permission.permissible_conditions(:product).is_a?(Hash)
  end
end
