# -*- coding: utf-8 -*-
require File.dirname(__FILE__) + '/../test_helper'
require 'workflow_controller'

class WorkflowControllerTest < ActionController::TestCase
  fixtures(:domains, :users, :products, :displays, :items,
           :search_conditions, :search_condition_items,
           :grant_ons, :permissions)

  def setup
    @controller = WorkflowController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")

    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # マッチするルートが無い場合
  def test_pending_issues_list_0
    @clients = { :action => mock('action'), :probe => mock('probe') }
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(@clients[:probe])
    routes = (1..100).map{|n|
      r = "route_#{n}"
      WorkflowStruct::Route.new(:workflow     => r,
                                :workflow_aux => "aux_#{n % 3}",
                                :name         => "name_#{n}")
    }
    pending_issues = (1..100).map{|n|
      WorkflowStruct::IssueStatus.new(:message_body    => "200804-#{'%05d' % n}",
                                      :issue_name      => "issue_name#{n}",
                                      :issuer_name     => "issuer_name#{n}",
                                      :issued_at       => Date.today.to_s,
                                      :authorizer_name => "authorizer_name#{n}",
                                      :issue_remark    => "issue_remark#{n}",
                                      :description     => "description#{n}"
                                      )
    }
    @routes = WorkflowStruct::ListRoute.new(:list => routes)
    @pending_issues = WorkflowStruct::ListIssueStatus.new(:list => pending_issues)
    @clients[:probe].expects(:routes).with(anything).returns(@routes)
    @clients[:probe].expects(:pending_issues).with(anything, anything).returns(@pending_issues)
    get :pending_issues_list
    assert_response :success
    assert_select "div"
    assert_equal 1, assigns(:pages).current.number
  end

  def test_pending_issues_list_1
    @clients = { :action => mock('action'), :probe => mock('probe') }
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(@clients[:probe])
    routes = (1..100).map{|n|
      if n == 1
        r = "r"
      else
        r = "route_#{n}"
      end
      WorkflowStruct::Route.new(:workflow     => r,
                                :workflow_aux => "aux_#{n % 3}",
                                :name         => "name_#{n}")
    }
    pending_issues = (1..100).map{|n|
      WorkflowStruct::IssueStatus.new(:message_body    => "200804-#{'%05d' % n}",
                                      :issue_name      => "issue_name#{n}",
                                      :issuer_name     => "issuer_name#{n}",
                                      :issued_at       => Date.today.to_s,
                                      :authorizer_name => "authorizer_name#{n}",
                                      :issue_remark    => "issue_remark#{n}",
                                      :description     => "description#{n}"
                                      )
    }
    @routes = WorkflowStruct::ListRoute.new(:list => routes)
    @pending_issues = WorkflowStruct::ListIssueStatus.new(:list => pending_issues)
    @clients[:probe].expects(:routes).with(anything).returns(@routes)
    @clients[:probe].expects(:pending_issues).with(anything, anything).returns(@pending_issues)
    get :pending_issues_list
    assert_response :success
    assert_select "div"
    assert_equal 1, assigns(:pages).current.number
  end

  # マッチするルートが無い場合
  def test_user_issues_list_0
    @clients = { :action => mock('action'), :probe => mock('probe') }
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(@clients[:probe])
    routes = (1..100).map{|n|
      r = "route_#{n}"
      WorkflowStruct::Route.new(:workflow     => r,
                                :workflow_aux => "aux_#{n % 3}",
                                :name         => "name_#{n}")
    }
    user_issues = (1..100).map{|n|
      WorkflowStruct::IssueStatus.new(:message_body    => "200804-#{'%05d' % n}",
                                      :issue_name      => "issue_name#{n}",
                                      :issuer_name     => "issuer_name#{n}",
                                      :issued_at       => Date.today.to_s,
                                      :authorizer_name => "authorizer_name#{n}",
                                      :issue_remark    => "issue_remark#{n}",
                                      :description     => "description#{n}"
                                      )
    }
    @routes = WorkflowStruct::ListRoute.new(:list => routes)
    @user_issues = WorkflowStruct::ListIssueStatus.new(:list => user_issues)
    @clients[:probe].expects(:routes).with(anything).returns(@routes)
    @clients[:probe].expects(:my_issues).with(anything, anything, anything).returns(@user_issues)
    get :user_issues_list
    assert_response :success
    assert_equal 1, assigns(:pages).current.number
  end

  def test_user_issues_list_1
    @clients = { :action => mock('action'), :probe => mock('probe') }
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(@clients[:probe])
    routes = (1..100).map{|n|
      if n == 1
        r = "r"
      else
        r = "route_#{n}"
      end
      WorkflowStruct::Route.new(:workflow     => r,
                                :workflow_aux => "aux_#{n % 3}",
                                :name         => "name_#{n}")
    }
    user_issues = (1..100).map{|n|
      WorkflowStruct::IssueStatus.new(:message_body    => "200804-#{'%05d' % n}",
                                      :issue_name      => "issue_name#{n}",
                                      :issuer_name     => "issuer_name#{n}",
                                      :issued_at       => Date.today.to_s,
                                      :authorizer_name => "authorizer_name#{n}",
                                      :issue_remark    => "issue_remark#{n}",
                                      :description     => "description#{n}"
                                      )
    }
    @routes = WorkflowStruct::ListRoute.new(:list => routes)
    @user_issues = WorkflowStruct::ListIssueStatus.new(:list => user_issues)
    @clients[:probe].expects(:routes).with(anything).returns(@routes)
    @clients[:probe].expects(:my_issues).with(anything, anything, anything).returns(@user_issues)
    get :user_issues_list
    assert_response :success
    assert_select "div"
    assert_equal 1, assigns(:pages).current.number
  end

  def test_accept_all
    @clients = { :action => mock('action'), :probe => mock('probe') }
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowActionApi, anything).at_most_once.returns(@clients[:action])
    @workflow_response = WorkflowStruct::Response.new(:status => 'success', :information => "aaa")
    @clients[:action].expects(:accept_all).with(anything, anything).returns(@workflow_response)
    post :accept_all, :lump => %w[1 2 3 4 5]
    assert_response :redirect
    assert_redirected_to :action => 'pending_issues_list'
  end

  LOG_LIST = [{
                :issuer_name => "a",
                :route => WorkflowStruct::Route.new(:name => "rx", :workflow => "r", :workflow_aux => "x"),
                :message_body => "D000000001",
                :stage_name => "ステージ1",
                :timestamp => "2008/10/30 10:00:00",
                :content => "承認",
                :person_name => "Amy",
              }, {
                :issuer_name => "a",
                :route => WorkflowStruct::Route.new(:name => "rx", :workflow => "r", :workflow_aux => "x"),
                :message_body => "D000000002",
                :stage_name => "ステージ2",
                :timestamp => "2008/10/31 12:00:00",
                :content => "棄却",
                :person_name => "Bob",
              }, {
                :issuer_name => "a",
                :route => WorkflowStruct::Route.new(:name => "ry", :workflow => "r", :workflow_aux => "y"),
                :message_body => "D000000003",
                :stage_name => "ステージA",
                :timestamp => "2008/11/01 17:00:00",
                :content => "申請",
                :person_name => "Charlie",
              },
             ].map do |x|
    WorkflowStruct::ProcessStatus.new(x)
  end

  # WorkflowController#log_per_person を条件無しで呼ぶ。
  def test_log_per_person__without_condition
    @request.session[:user_id] = User.find_by_login("admin")
    CacheEachRequest.clear
    client = mock('probe')
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(client)
    list_process_status = WorkflowStruct::ListProcessStatus.new(:list => LOG_LIST)
    client.expects(:processes).with(anything, anything).returns(list_process_status)
    get :log_per_person
    assert_response :success
    assert_select "div"
    assert_template "log_per_person"
    assert_equal 1, assigns(:pages).current.number
    assert_select "table[class~=pagination_list]>tbody>tr", 3
  end

  # WorkflowController#log_per_issue を条件無しで呼ぶ。
  def test_log_per_issue__without_condition
    @request.session[:user_id] = User.find_by_login("admin")
    CacheEachRequest.clear
    client = mock('probe')
    ActionWebService::Client::Soap.expects(:new).
      with(WorkflowProbeApi, anything).at_most_once.returns(client)
    list_process_status = WorkflowStruct::ListProcessStatus.new(:list => LOG_LIST)
    client.expects(:processes).with(anything, anything).returns(list_process_status)
    get :log_per_issue
    assert_response :success
    assert_select "div"
    assert_template "log_per_issue"
    assert_equal 1, assigns(:pages).current.number
    assert_select "table[class~=pagination_list]>tbody>tr", 3
  end

end
