# -*- coding: utf-8 -*-
require 'test_helper'

class Pick::PostControllerTest < ActionController::TestCase
  fixtures :domains, :config_pickers, :people, :users, :posts

  def setup
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  def test_search__without_params
    post :search, :rfw => { :post_id => 'dummy', :post_name => 'dummy' }
    assert_response :success
    assert_template "search"
    assert_select "div > ul"
  end

  def test_search__with_name
    post :search, :name => "チーフ", :rfw => { :post_id => 'dummy', :post_name => 'dummy' }
    assert_response :success
    assert_template "search"
    assert_select "div > ul"
  end

end
