# -*- coding: utf-8 -*-
require 'test_helper'

class Pick::MatterControllerTest < ActionController::TestCase
  fixtures :domains, :config_pickers, :people, :users, :matters

  def setup
    @request.session[:user_id] = User.find_by_login("admin")
  end

  # rfw パラメータの有無を確認する。
  def test_check_rfw_parameters
    assert_raise(ApplicationController::ClientError) do
      post :search
    end
  end

  # 必要最小限のパラメータで一覧を返す。
  def test_search__with_neihter_code_nor_name
    post :search, :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "search"
    assert_select "table.result>tr.matter"
  end

  # パラメータ code で検索する。
  def test_search__with_code
    post :search, :code => "A", :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "search"
    assert_select "table.result>tr.matter"
  end

  # パラメータ name で検索する。
  def test_search__with_name
    post :search, :name => "案件", :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "search"
    assert_select "table.result>tr.matter"
  end

  # 必要最小限のパラメータで一覧を返す。
  def test_narrow__with_neihter_code_nor_name
    post :narrow, :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "narrow"
    assert_select "table.result>tr.matter"
  end

  # パラメータ code で検索する。
  def test_narrow__with_code
    post :search, :code => "no such code", :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "search"
    assert_select "table.result>tr.matter", :count => 0
  end

  # パラメータ name で検索する。
  def test_narrow__with_name
    post :search, :name => "no such name", :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_template "search"
    assert_select "table.result>tr.matter", :count => 0
  end

  # 現在の案件情報を保存する。
  def test_save_current
    post :save_current, :current_id => 1, :rfw => {:matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    assert_select "table.result>tr.matter", :count => 0
  end

  # 現在の案件情報をリセットする。
  def test_reset_current
    post :reset_current, :rfw => {:narrowing_text => "text_xxx", :matter_name => "xxx", :matter_id => "xxx_id"}
    assert_response :success
    body = JSON.load(@response.body)
    assert_equal "", body["text_xxx"]
    assert_equal "", body["xxx_id"]
  end

end
