require 'test_helper'

class Pick::CompanyControllerTest < ActionController::TestCase
  fixtures :domains, :config_pickers, :people, :users, :companies

  def setup
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  def test_search__without_params
    post :search, :rfw => { :company_id => 'dummy', :company_name => 'dummy' }
    assert_response :success
    assert_template "search"
    assert_select "div.result"
  end

  def test_search_with_name
    post :search, :name => "XYZ", :rfw => { :company_id => 'dummy', :company_name => 'dummy' }
    assert_response :success
    assert_template "search"
    assert_select "div.result"
    assert_select "div.result > ul > li"
  end

end
