# -*- coding: utf-8 -*-
# app/controllers/output_controller.rb のクラス OutputController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'output_controller'

# Re-raise errors caught by the controller.
class OutputController; def rescue_action(e) raise e end; end

class OutputControllerTest < Test::Unit::TestCase
  fixtures :users, :products, :displays, :items, :config_outputs, :config_output_items, :display_narrowings, :narrowings

  def setup
    @controller = OutputController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
    def @request.user_agent
      "MY OWN USER AGENT"
    end
  end

  # OutputController#test に適切な ID を与えられる場合に成功することをテストする。
  def test_test
    get :test, :id => 5
    assert_response :success
    assert_template "test"
    assert_select "div"
  end

  # OutputController#edit に適切な ID を与えられる場合に成功することをテストする。
  def test_edit
    get :edit, :id => 5
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end

  # OutputController#sort に適切な ID を与えられる場合に成功することをテストする。
  def test_sort
    get :sort, :id => 5
    assert_response :success
    assert_equal "text/html", @response.content_type
    assert_equal "nil", @response.body
  end

  # OutputController#sort で出力項目の順番を変更することをテストする。
  def test_sort__reverse
    get :sort, :id => 5, :config_output_items_tbody => [4, 3]
    assert_response :success
    assert_equal "text/html", @response.content_type
    assert_equal "[4, 3]", @response.body
    config_output = ConfigOutput.find(2)
    assert_equal [4, 3], config_output.config_output_items.map(&:id)
  end

  # OutputController#save に適切な ID を与えられる場合に成功することをテストする。
  def test_save
    post :save, :id => 5
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end

  # OutputController#download にパラメータがないと失敗することをテストする。
  def test_download__without_params
    post :download, :id => 9994
    assert_response 400
  end

  # OutputController#download に適切な ID を与えられる場合に成功することをテストする。
  def test_download
    post :download, :id => 9994, :path => "no_such_path"
    assert_response :success
    assert_equal "text/csv", @response.content_type
  end

  # OutputController#clear に適切な ID を与えられる場合に成功することをテストする。
  def test_clear
    post :clear, :id => 5
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end
end
