# -*- coding: utf-8 -*-
# app/controllers/attachment_controller.rb のクラス AttachmentContoller をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'attachment_controller'

# Re-raise errors caught by the controller.
class AttachmentController; def rescue_action(e) raise e end; end

class AttachmentControllerTest < Test::Unit::TestCase
  fixtures(:domains, :users, :people,
           :config_attachments, :storages, :storage_objects, :binary_objects,
           :attachments, :matters)

  def setup
    @controller = AttachmentController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")

    @attachment = {
      :description => "xyz",
      :file_content => ActionController::TestUploadedFile.new(fixture_path + "/files/foo.txt", "text/plain"),
    }
  end

  # AttachmentController#show に適切なパラメータが与えられた場合に
  # - テンプレート "show" による出力を行う
  # ことをテストする。
  def test_show
    get :show, :id => 1, :type => "Matter"
    assert_response :success
    assert_template "show"
    assert_select "div"
  end

  # AttachmentController#edit に適切なパラメータが与えられた場合に
  # - テンプレート "edit" による出力を行う
  # ことをテストする。
  def test_edit
    get :edit, :id => 1, :type => "Matter"
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end

  # AttachmentController#upload に適切なパラメータが与えられた場合に
  # サーバのファイルシステムにアップロード動作を行うことをテストする。
  def test_upload_storage_object
    @attachment[:file_type] = "StorageObject"
    begin
      post :upload, :id => 1, :type => "Matter", :attachment => @attachment
    rescue SystemCallError
      # could be happened
      return
    end
    assert_response :success
  end

  # AttachmentController#upload に適切なパラメータが与えられた場合に
  # データベースにアップロード動作を行うことをテストする。
  def test_upload_binary_object
    @attachment[:file_type] = "BinaryObject"
    post :upload, :id => 1, :type => "Matter", :attachment => @attachment
    assert_response :success
  end

  # AttachmentController#delete に適切なパラメータが与えられた場合に
  # 添付されたファイルを削除することをテストする。
  def test_delete
    post :delete, :id => 1, :type => "Matter", :attachment => [1, 3]
    assert_response :success
  end

  # AttachmentController#download に適切なパラメータが与えられた場合に
  # サーバのファイルシステム上のファイルを出力することをテストする。
  def test_download_storage_object
    get :download, :id => 3
    assert_response :success
    File.unlink(RAILS_ROOT + '/tmp/3') rescue nil
  end

  # AttachmentController#download に適切なパラメータが与えられた場合に
  # データベース内のファイルを出力することをテストする。
  def test_download_binary_object
    get :download, :id => 4
    assert_response :success
  end

  # 保存場所が利用できないときにはファイルを保存せずに完了。
  def test_upload__issue543
    storage = Storage.current
    storage.update_attributes(:root => "boo boo boo")
    @attachment[:file_type] = "StorageObject"
    post :upload, :id => 1, :type => "Matter", :attachment => @attachment
    assert_response :success
    File.unlink(RAILS_ROOT + '/tmp/4') rescue nil
  end
end
