# -*- ruby -*-
# vim:set ft=ruby:

require "config/initializers/app"

desc "Update pot/po files."
task :updatepo do
  require "gettext/utils"
  ENV["MSGMERGE_PATH"] ||= "msgmerge --sort-output"
  GetText.update_pofiles(
    ::App::GETTEXT_DOMAINNAME,
    Dir.glob("{app,config,lib}/**/*.{rb,rhtml,rjs,erb}"),
    "#{::App::PACKAGE} #{::App::VERSION}"
  )
end

desc "Create mo-files"
task :makemo do
  require "gettext/utils"
  GetText.create_mofiles(true, "po", "locale")
end

desc "Update po and mo files according to DB."
task :gettext_from_db do
  script = "PoTranslation.database_only_update_po_and_make_mo_all"
  ruby = ENV["RUBY"]
  begin
    require "rbconfig"
    ruby ||= File.join(
      Config::CONFIG["bindir"],
      Config::CONFIG["ruby_install_name"] + Config::CONFIG["EXEEXT"]
      )
  rescue LoadError
    ruby ||= "ruby"
  end
  system(ruby, "script/runner", script)
end

def with_po_data(&block)
  require "gettext/poparser"
  require "gettext/rmsgmerge"
  file = RAILS_ROOT + "/po/ja/#{::App::GETTEXT_DOMAINNAME}.po"
  parser = GetText::PoParser.new
  data = GetText::RMsgMerge::PoData.new
  parser.parse(File.open(file).read, data, false)
  yield(data)
end

namespace :gettext do
  namespace :po do
    namespace :ja do
      desc "Extract msgids from po/ja/#{::App::GETTEXT_DOMAINNAME}.po."
      task :msgid => :environment do
        with_po_data do |data|
          case ENV["FILTER"]
          when "production"
            filter = lambda do |x|
              /(?:test|Test|ProductGenerator)/ =~ x ? false : true
            end
          else
            filter = lambda {|x| x} # always true
          end
          data.each_msgid do |id|
            if id.include?("\000")
              ids = id.split(/\000/)
              msgid        = ids[0].gsub('"', '\"')
              msgid_plural = ids[1].gsub('"', '\"')
              print "PoMessagePlural,\"#{msgid}\",\"#{msgid_plural}\"\n" if filter.call(msgid)
            else
              msgid = id.gsub('"', "\\\"")
              print "PoMessageSingular,\"#{msgid}\"\n" if filter.call(msgid)
            end
          end
        end
      end

      desc "Dump po/ja/#{::App::GETTEXT_DOMAINNAME}.po to .yml."
      task :message => :environment do
        with_po_data do |data|
          n = 100000
          data.each_msgid do |id|
            n = n + 1
            print "#{::App::GETTEXT_DOMAINNAME}_#{n}:\n"
            print "  id: #{n}\n"
            print "  domain_id: 1\n"
            print "  msgctxt: \"\"\n"
            if id.include?("\000")
              ids = id.split(/\000/)
              msgid        = ids[0].gsub('"', '\"')
              msgid_plural = ids[1].gsub('"', '\"')
              print "  type: PoMessagePlural\n"
              print "  msgid: #{msgid}\n"
              print "  msgid_plural: #{msgid_plural}\n"
              print "  msgid_n: 1 # MODIFY if needed\n"
            else
              msgid = id.gsub('"', "\\\"")
              print "  type: PoMessageSingular\n"
              print "  msgid: \"#{msgid}\"\n"
              print "  msgid_plural: \n"
              print "  msgid_n: \n"
            end
          end
        end
      end

      task :translation => :environment do
        with_po_data do |data|
          n = 100000
          data.each_msgid do |id|
            n = n + 1
            print "#{::App::GETTEXT_DOMAINNAME}_#{n}_ja:\n"
            print "  id: #{n}\n"
            print "  domain_id: 1\n"
            print "  type: PoTranslationJa\n"
            print "  po_message_id: #{n}\n"
            msgstr = data.msgstr(id).gsub('"', '\"')
            if id.include?("\000")
              print "  msgstr_0: \"#{msgstr}\"\n"
            else
              print "  msgstr: \"#{msgstr}\"\n"
            end
          end
        end
      end
    end
  end
end
