# -*- coding: utf-8 -*-
require 'readonly_helper'

# :readonly => true の場合 'readonly' という class も付与する。
module ReadonlyFormTagHelper

  def self.included(base)
    base.module_eval do
      alias_method_chain :text_field_tag, :readonly
      alias_method_chain :text_area_tag, :readonly
    end
  end

  def text_field_tag_with_readonly(name, value=nil, options={})
    text_field_tag_without_readonly(name, value, ReadonlyHelper.options_with_readonly(options))
  end

  def text_area_tag_with_readonly(name, content=nil, options={})
    text_area_tag_without_readonly(name, content, ReadonlyHelper.options_with_readonly(options))
  end

end

ActionView::Helpers::FormTagHelper.__send__(:include, ReadonlyFormTagHelper)
