# -*- coding: utf-8 -*-
module ProjectCollaboration
  module ProjectHelper

    # コントローラで利用する。
    module Controller

      def prepare(project_id, segment_id=nil)
        prepare_projects
        if !project_id.blank?
          @project = picker_model_class("Project").find(project_id)
          @segments = @project.segments
        elsif !segment_id.blank?
          segment = picker_model_class("ProjectSegment").find(segment_id)
          @project = segment.project
          @segments = @project.segments
        end
      rescue ActiveRecord::RecordNotFound
        @project = nil
      end

      def prepare_projects
        @code = params[:code]
        @name = params[:name]
        projects = picker_model_class("Project").find(:all, :select => "id, code, name", :order => "code")
        projects = projects.select {|m| m.code && m.code.index(@code)} unless @code.blank?
        projects = projects.select {|m| m.name && m.name.index(@name)} unless @name.blank?
        @projects = projects
      end

      def prepare_segments
        @project = picker_model_class("Project").find(params[:project_id])
        @segments = @project.segments
      rescue ActiveRecord::RecordNotFound
        @project = nil
      end

      private

      def set_current_project_and_segment
        @current_segment = picker_model_class("ProjectSegment").find_by_id(session[:project_segment_id]) if session[:project_segment_id]
        @current_project = @current_segment.project if @current_segment
        @current_project ||= picker_model_class("Project").find_by_id(session[:project_id]) if session[:project_id]
      end

      def expose_writable_only
        if @project
          @project = nil unless @project.writable?
        end
        if @projects
          @projects = @projects.select(&:writable?)
        end
        if @segments
          @segments = @segments.select(&:writable?)
        end
      end

    end

    # ヘルパーで利用する。
    module Helper

      def current_project_code_tag
        text_field_tag("current_project_code", @current_project ? @current_project.code : '',:size => "15", :readonly => true)
      end

      def current_project_name_tag
        text_field_tag("current_project_name", @current_project ? @current_project.name : '',:size => "53", :readonly => true)
      end

      def current_segment_name_tag
        text_field_tag("current_segment_name", @current_segment ? @current_segment.name : '',:size => "71", :readonly => true)
      end

      def radio_button_to_save_project(project)
        checked = !session[:project_id].blank? && project.id == session[:project_id].to_i
        radio_button_tag("saved", "project_#{project.id}", checked)
      end

      def radio_button_to_save_segment(segment)
        checked = !session[:project_segment_id].blank? && segment.id == session[:project_segment_id].to_i
        radio_button_tag("saved", "segment_#{segment.id}", checked)
      end

      def link_to_pick_project(project, action)
        rfw_link_to_pick(h(project.name), {
                           :display_narrowing_id => display_narrowing_id("pick/project", action),
                           :narrowing_text => project.to_text,
                           :project_id => project.id,
                           :project_segment_id => '',
                         })
      end

      def link_to_pick_segment(segment, path, action)
        rfw_link_to_pick(h(segment.name), {
                           :display_narrowing_id => display_narrowing_id(path, action),
                           :narrowing_text => segment.to_text,
                           :project_id => @project.id,
                           :project_segment_id => segment.id,
                         })
      end

    end

  end
end
